<?php


namespace Elementor;

use Elementor\Widget_Base;

class Gallery_Widget extends Widget_Base {
    public function get_name() {
        return 'gallery-widget';
    }

    public function get_title() {
        return 'Gallery Widget';
    }

    public function get_icon() {
        return 'eicon-gallery-masonry';
    }

    public function get_categories() {
        return [ 'myew-for-elementor' ];
    }

    public function get_script_depends() {
        return [
            'hulsia-addons-script'
        ];
    }

    protected function _register_controls() {
        $this->start_controls_section(
            'gallery_section',
            [
                'label' => 'Gallery',
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'slides',
            [
                'label' => 'Slides',
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'slide',
                        'label' => 'Slide',
                        'type' => \Elementor\Controls_Manager::MEDIA,
                        'default' => [
                            'url' => '',
                            'title' => '',
                        ],
                    ],
                    [
                        'name' => 'images',
                        'label' => 'Images',
                        'type' => \Elementor\Controls_Manager::GALLERY,
                        'default' => [],
                        'limit' => 5,
                    ],
                ],
                'default' => [],
                'title_field' => '{{{ slide.title }}}',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        if (empty($settings['slides'])) {
            return;
        }

        $carousel_id = 'carousel-' . $this->get_id();

        $carousel_html = '<div id="' . $carousel_id . '" class="carousel carousel-grid">';

        foreach ($settings['slides'] as $slide) {
            $carousel_html .= '<div class="slide">';

            foreach (array_slice($slide['images'], 0, 5) as $image) {
                $carousel_html .= '<div class="splide_child">';
                $carousel_html .= '<img src="' . $image['url'] . '" alt="">';
                $carousel_html .= '</div>';
            }

            $carousel_html .= '</div>';
        }

        $carousel_html .= '</div>';

        echo $carousel_html;
    }
}


Plugin::instance()->widgets_manager->register_widget_type( new Gallery_Widget() );
