<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
jQuery(document).ready(function($) {
    function calculerHauteurInitiale($element) {
        let $premierParagraphe = $element.find('p:first-child');
        let hauteurInitiale;
		let hauteurMax = 216;
		let windowWidth = $(window).width();

        if (windowWidth < 768) { // Pour les écrans de largeur inférieure à 768px (taille mobile)
            hauteurMax = 396; // Utiliser 296 comme hauteur initiale sur mobile
        } 
        if ($premierParagraphe.height() >= 100) {
            // Si la hauteur du premier paragraphe est supérieure ou égale à 100 pixels, utiliser sa hauteur comme hauteur initiale
            hauteurInitiale = $premierParagraphe.height();
        } else {
            // Sinon, calculer la hauteur initiale en ajoutant les hauteurs des deux premiers paragraphes
            hauteurInitiale = 0;
            $element.find('p').each(function(index) {
                if (index < 2) {
                    hauteurInitiale += $(this).outerHeight(true);
                }
            });
            hauteurInitiale = Math.min(hauteurInitiale, hauteurMax); // Limiter la hauteur initiale à 216 pixels
        }
        return hauteurInitiale;
    }

    $('.texte_read_more').each(function() {
        let $_this = $(this);
        let hauteurInitiale = calculerHauteurInitiale($_this);

        // Appliquer la hauteur calculée comme max-height au conteneur
        $_this.css('max-height', hauteurInitiale + 'px');
    });

    $('.btn_read_more').each(function() {
        let $_more = $(this);
        $_more.find('a').click(function(e) {
            e.preventDefault();
            let data_more = $_more.attr('data-more');
            let $_texte_read_more = $(data_more);

            let hauteurTotale = $_texte_read_more.find(".elementor-widget-container").height();

            // Vérifier si la hauteur actuelle est égale à la hauteur totale, puis ajuster en conséquence
            if ($_texte_read_more.outerHeight(true) === hauteurTotale) {
                // Si la hauteur actuelle est égale à la hauteur totale, réinitialiser la hauteur aux deux premiers paragraphes
                let hauteurInitiale = calculerHauteurInitiale($_texte_read_more);
                $_texte_read_more.css('max-height', hauteurInitiale + 'px');
                $(this).find('.elementor-button-text').text('Lire la suite');
            } else {
                // Si la hauteur actuelle n'est pas égale à la hauteur totale, mettre la hauteur totale pour afficher tous les éléments
                $_texte_read_more.css('max-height', hauteurTotale + 'px');
                $(this).find('.elementor-button-text').text('Réduire le texte');
            }
        });
    });
});</script>
<!-- end Simple Custom CSS and JS -->
