<?php defined( 'ABSPATH' ) OR die( 'This script cannot be accessed directly.' );

/**
 * Theme's Color Schemes
 *
 * @filter us_config_color-schemes
 */

return array(
	array(
		'title' => __( 'Night Fire', 'us' ),
		'values' => array(
			'color_body_bg' => '#222',

			'color_header_top_bg' => '#2b2b2b',
			'color_header_top_text' => '#ccc',
			'color_header_top_text_hover' => '#df1238',
			'color_header_middle_bg' => '#161616',
			'color_header_middle_text' => '#ccc',
			'color_header_middle_text_hover' => '#df1238',
			'color_header_bottom_bg' => '#2b2b2b',
			'color_header_bottom_text' => '#ccc',
			'color_header_bottom_text_hover' => '#df1238',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#df1238',
			'color_chrome_toolbar' => '#2b2b2b',

			'color_content_bg' => '#2b2b2b',
			'color_content_bg_alt' => '#161616',
			'color_content_border' => '#444',
			'color_content_heading' => '#fff',
			'color_content_text' => '#ccc',
			'color_content_link' => '#df1238',
			'color_content_link_hover' => '#fff',
			'color_content_primary' => 'linear-gradient(60deg,#ff6a3f,#df1238)',
			'color_content_secondary' => '#ff6a3f',
			'color_content_faded' => '#888',

			'color_alt_content_bg' => '#161616',
			'color_alt_content_bg_alt' => '#2b2b2b',
			'color_alt_content_border' => '#444',
			'color_alt_content_heading' => '#fff',
			'color_alt_content_text' => '#ccc',
			'color_alt_content_link' => '#df1238',
			'color_alt_content_link_hover' => '#ff6a3f',
			'color_alt_content_primary' => 'linear-gradient(60deg,#ff6a3f,#df1238)',
			'color_alt_content_secondary' => '#ff6a3f',
			'color_alt_content_faded' => '#888',

			'color_footer_bg' => '#161616',
			'color_footer_bg_alt' => '#2b2b2b',
			'color_footer_border' => '#444',
			'color_footer_text' => '#888',
			'color_footer_link' => '#df1238',
			'color_footer_link_hover' => '#ff6a3f',

			'color_subfooter_bg' => '#2b2b2b',
			'color_subfooter_bg_alt' => '#161616',
			'color_subfooter_border' => '#444',
			'color_subfooter_text' => '#888',
			'color_subfooter_link' => '#df1238',
			'color_subfooter_link_hover' => '#ff6a3f',
		),
	),
	array(
		'title' => __( 'Purple Pearl', 'us' ),
		'values' => array(
			'color_body_bg' => '#313233',

			'color_header_top_bg' => 'linear-gradient(215deg,#607cfd,#9e78ee)',
			'color_header_top_text' => '#fff',
			'color_header_top_text_hover' => '#fff',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#313233',
			'color_header_middle_text_hover' => '#607cfd',
			'color_header_bottom_bg' => 'linear-gradient(215deg,#607cfd,#9e78ee)',
			'color_header_bottom_text' => '#fff',
			'color_header_bottom_text_hover' => '#fff',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#607cfd',
			'color_chrome_toolbar' => '#9e78ee',

			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f3f2f5',
			'color_content_border' => '#e4e3e8',
			'color_content_heading' => '#313233',
			'color_content_text' => '#313233',
			'color_content_link' => '#9e78ee',
			'color_content_link_hover' => '#607cfd',
			'color_content_primary' => 'linear-gradient(215deg,#607cfd,#9e78ee)',
			'color_content_secondary' => 'linear-gradient(75deg,#607cfd,#9e78ee)',
			'color_content_faded' => '#999c9e',

			'color_alt_content_bg' => '#f3f2f5',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#e4e3e8',
			'color_alt_content_heading' => '#313233',
			'color_alt_content_text' => '#313233',
			'color_alt_content_link' => '#9e78ee',
			'color_alt_content_link_hover' => '#607cfd',
			'color_alt_content_primary' => 'linear-gradient(215deg,#607cfd,#9e78ee)',
			'color_alt_content_secondary' => 'linear-gradient(75deg,#607cfd,#9e78ee)',
			'color_alt_content_faded' => '#999c9e',

			'color_footer_bg' => '#18191a',
			'color_footer_bg_alt' => '#313233',
			'color_footer_border' => '#313233',
			'color_footer_text' => '#6b6d6e',
			'color_footer_link' => '#999c9e',
			'color_footer_link_hover' => '#607cfd',

			'color_subfooter_bg' => '#313233',
			'color_subfooter_bg_alt' => '#18191a',
			'color_subfooter_border' => '#4b4c4d',
			'color_subfooter_text' => '#999c9e',
			'color_subfooter_link' => '#e4e3e8',
			'color_subfooter_link_hover' => '#607cfd',
		),
	),
	array(
		'title' => __( 'Light Pink', 'us' ),
		'values' => array(
			'color_body_bg' => '#eee',

			'color_header_top_bg' => '#fa96aa',
			'color_header_top_text' => '#fff',
			'color_header_top_text_hover' => '#fff',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#1a1a1a',
			'color_header_middle_text_hover' => '#fa96aa',
			'color_header_bottom_bg' => '#fff',
			'color_header_bottom_text' => '#1a1a1a',
			'color_header_bottom_text_hover' => '#fa96aa',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_chrome_toolbar' => '#f7f0f2',

			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f7f0f2',
			'color_content_border' => '#ede1e3',
			'color_content_heading' => '#1a1a1a',
			'color_content_text' => '#333',
			'color_content_link' => '#fa96aa',
			'color_content_link_hover' => '#f73453',
			'color_content_primary' => '#fa96aa',
			'color_content_secondary' => '#f73453',
			'color_content_faded' => '#999',

			'color_alt_content_bg' => '#f7f0f2',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#ebdddf',
			'color_alt_content_heading' => '#1a1a1a',
			'color_alt_content_text' => '#333',
			'color_alt_content_link' => '#fa96aa',
			'color_alt_content_link_hover' => '#f73453',
			'color_alt_content_primary' => '#fa96aa',
			'color_alt_content_secondary' => '#f73453',
			'color_alt_content_faded' => '#999',

			'color_footer_bg' => '#222',
			'color_footer_bg_alt' => '#1a1a1a',
			'color_footer_border' => '#333',
			'color_footer_text' => '#999',
			'color_footer_link' => '#ccc',
			'color_footer_link_hover' => '#f73453',

			'color_subfooter_bg' => '#1a1a1a',
			'color_subfooter_bg_alt' => '#222',
			'color_subfooter_border' => '#282828',
			'color_subfooter_text' => '#bbb',
			'color_subfooter_link' => '#fff',
			'color_subfooter_link_hover' => '#f73453',
		),
	),
	array(
		'title' => __( 'Gentle Blue', 'us' ),
		'values' => array(
			'color_body_bg' => '#0f131f',

			'color_header_top_bg' => '#fff',
			'color_header_top_text' => '#727f9f',
			'color_header_top_text_hover' => '#646cfd',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#35415b',
			'color_header_middle_text_hover' => '#646cfd',
			'color_header_bottom_bg' => '#fff',
			'color_header_bottom_text' => '#727f9f',
			'color_header_bottom_text_hover' => '#646cfd',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_chrome_toolbar' => '#f2f4f7',

			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f2f4f7',
			'color_content_border' => '#e3e7f0',
			'color_content_heading' => '#0f131f',
			'color_content_text' => '#35415b',
			'color_content_link' => '#646cfd',
			'color_content_link_hover' => '#35415b',
			'color_content_primary' => '#646cfd',
			'color_content_secondary' => '#35415b',
			'color_content_faded' => '#727f9f',

			'color_alt_content_bg' => '#f2f4f7',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#e3e7f0',
			'color_alt_content_heading' => '#0f131f',
			'color_alt_content_text' => '#35415b',
			'color_alt_content_link' => '#646cfd',
			'color_alt_content_link_hover' => '#35415b',
			'color_alt_content_primary' => '#646cfd',
			'color_alt_content_secondary' => '#35415b',
			'color_alt_content_faded' => '#727f9f',

			'color_footer_bg' => '#0f131f',
			'color_footer_bg_alt' => '#1c2130',
			'color_footer_border' => '#2b3242',
			'color_footer_text' => '#8d9096',
			'color_footer_link' => '#646cfd',
			'color_footer_link_hover' => '#fff',

			'color_subfooter_bg' => '#35415b',
			'color_subfooter_bg_alt' => '#2b3242',
			'color_subfooter_border' => '#727f9f',
			'color_subfooter_text' => '#9ba5bf',
			'color_subfooter_link' => '#e3e7f0',
			'color_subfooter_link_hover' => '#fff',
		),
	),
	array(
		'title' => __( 'White Pink', 'us' ),
		'values' => array(
			'color_body_bg' => '#eee',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#333',
			'color_header_middle_text_hover' => '#e95095',
			'color_chrome_toolbar' => '#f5f5f5',
			'color_header_top_bg' => 'linear-gradient(0deg,#f5f5f5,#fff)',
			'color_header_top_text' => '#333',
			'color_header_top_text_hover' => '#e95095',
			'color_header_bottom_bg' => '#f5f5f5',
			'color_header_bottom_text' => '#333',
			'color_header_bottom_text_hover' => '#e95095',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f5f5f5',
			'color_content_border' => '#e8e8e8',
			'color_content_heading' => '#1a1a1a',
			'color_content_text' => '#333',
			'color_content_link' => '#e95095',
			'color_content_link_hover' => '#7049ba',
			'color_content_primary' => 'linear-gradient(135deg,#e95095,#7049ba)',
			'color_content_secondary' => 'linear-gradient(135deg,#7049ba,#e95095)',
			'color_content_faded' => '#999',
			'color_alt_content_bg' => '#f5f5f5',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#ddd',
			'color_alt_content_heading' => '#1a1a1a',
			'color_alt_content_text' => '#333',
			'color_alt_content_link' => '#e95095',
			'color_alt_content_link_hover' => '#7049ba',
			'color_alt_content_primary' => 'linear-gradient(135deg,#e95095,#7049ba)',
			'color_alt_content_secondary' => 'linear-gradient(135deg,#7049ba,#e95095)',
			'color_alt_content_faded' => '#999',
			'color_subfooter_bg' => '#1a1a1a',
			'color_subfooter_bg_alt' => '#222',
			'color_subfooter_border' => '#282828',
			'color_subfooter_text' => '#bbb',
			'color_subfooter_link' => '#fff',
			'color_subfooter_link_hover' => '#e95095',
			'color_footer_bg' => '#222',
			'color_footer_bg_alt' => '#1a1a1a',
			'color_footer_border' => '#333',
			'color_footer_text' => '#999',
			'color_footer_link' => '#ccc',
			'color_footer_link_hover' => '#e95095',
		),
	),
	array(
		'title' => __( 'White Azure', 'us' ),
		'values' => array(
			'color_body_bg' => '#fff',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#3b3d40',
			'color_header_middle_text_hover' => '#277cea',
			'color_chrome_toolbar' => '#fff',
			'color_header_top_bg' => '#fff',
			'color_header_top_text' => '#666d70',
			'color_header_top_text_hover' => '#277cea',
			'color_header_bottom_bg' => '#fff',
			'color_header_bottom_text' => '#666d70',
			'color_header_bottom_text_hover' => '#277cea',
			'color_header_transparent_text' => '#3b3d40',
			'color_header_transparent_text_hover' => '#277cea',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#eee',
			'color_content_border' => '#eee',
			'color_content_heading' => '#3b3d40',
			'color_content_text' => '#3b3d40',
			'color_content_link' => '#277cea',
			'color_content_link_hover' => '#3b3d40',
			'color_content_primary' => '#277cea',
			'color_content_secondary' => '#3b3d40',
			'color_content_faded' => '#9da6a8',
			'color_alt_content_bg' => '#eee',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#ddd',
			'color_alt_content_heading' => '#3b3d40',
			'color_alt_content_text' => '#3b3d40',
			'color_alt_content_link' => '#277cea',
			'color_alt_content_link_hover' => '#3b3d40',
			'color_alt_content_primary' => '#277cea',
			'color_alt_content_secondary' => '#3b3d40',
			'color_alt_content_faded' => '#9da6a8',
			'color_subfooter_bg' => '#27282a',
			'color_subfooter_bg_alt' => '#323336',
			'color_subfooter_border' => '#3b3d40',
			'color_subfooter_text' => '#666d70',
			'color_subfooter_link' => '#9da6a8',
			'color_subfooter_link_hover' => '#277cea',
			'color_footer_bg' => '#27282a',
			'color_footer_bg_alt' => '#323336',
			'color_footer_border' => '#3b3d40',
			'color_footer_text' => '#666d70',
			'color_footer_link' => '#9da6a8',
			'color_footer_link_hover' => '#277cea',
		),
	),
	array(
		'title' => __( 'Fresh Mint', 'us' ),
		'values' => array(
			'color_body_bg' => '#e3e8e8',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#303640',
			'color_header_middle_text_hover' => '#00bf80',
			'color_chrome_toolbar' => '#f2f3f5',
			'color_header_top_bg' => '#f2f3f5',
			'color_header_top_text' => '#7c8491',
			'color_header_top_text_hover' => '#00bf80',
			'color_header_bottom_bg' => '#f2f3f5',
			'color_header_bottom_text' => '#7c8491',
			'color_header_bottom_text_hover' => '#00bf80',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f2f3f5',
			'color_content_border' => '#e1e5e8',
			'color_content_heading' => '#303640',
			'color_content_text' => '#303640',
			'color_content_link' => '#00bf80',
			'color_content_link_hover' => '#33bbff',
			'color_content_primary' => '#00bf80',
			'color_content_secondary' => '#33bbff',
			'color_content_faded' => '#7c8491',
			'color_alt_content_bg' => '#f2f3f5',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#d7dde0',
			'color_alt_content_heading' => '#303640',
			'color_alt_content_text' => '#303640',
			'color_alt_content_link' => '#00bf80',
			'color_alt_content_link_hover' => '#33bbff',
			'color_alt_content_primary' => '#00bf80',
			'color_alt_content_secondary' => '#33bbff',
			'color_alt_content_faded' => '#7c8491',
			'color_subfooter_bg' => '#434955',
			'color_subfooter_bg_alt' => '#303640',
			'color_subfooter_border' => '#545a66',
			'color_subfooter_text' => '#aab2bd',
			'color_subfooter_link' => '#d7dde0',
			'color_subfooter_link_hover' => '#33bbff',
			'color_footer_bg' => '#545a66',
			'color_footer_bg_alt' => '#434955',
			'color_footer_border' => '#676f7c',
			'color_footer_text' => '#d7dde0',
			'color_footer_link' => '#fff',
			'color_footer_link_hover' => '#33bbff',
		),
	),
	array(
		'title' => __( 'White Purple', 'us' ),
		'values' => array(
			'color_body_bg' => '#f6f6f6',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#222',
			'color_header_middle_text_hover' => '#ffc80a',
			'color_chrome_toolbar' => '#f6f6f6',
			'color_header_top_bg' => '#f6f6f6',
			'color_header_top_text' => '#333',
			'color_header_top_text_hover' => '#ffc80a',
			'color_header_bottom_bg' => '#f6f6f6',
			'color_header_bottom_text' => '#333',
			'color_header_bottom_text_hover' => '#ffc80a',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#ffc80a',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f6f6f6',
			'color_content_border' => '#dedede',
			'color_content_heading' => '#222',
			'color_content_text' => '#333',
			'color_content_link' => '#926ed4',
			'color_content_link_hover' => '#ffc80a',
			'color_content_primary' => '#926ed4',
			'color_content_secondary' => '#ffc80a',
			'color_content_faded' => '#666',
			'color_alt_content_bg' => 'linear-gradient(#f6f6f6,#fff)',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#dedede',
			'color_alt_content_heading' => '#222',
			'color_alt_content_text' => '#333',
			'color_alt_content_link' => '#926ed4',
			'color_alt_content_link_hover' => '#ffc80a',
			'color_alt_content_primary' => '#926ed4',
			'color_alt_content_secondary' => '#ffc80a',
			'color_alt_content_faded' => '#666',
			'color_subfooter_bg' => 'linear-gradient(#fff,#f6f6f6)',
			'color_subfooter_bg_alt' => '#fff',
			'color_subfooter_border' => '#dedede',
			'color_subfooter_text' => '#333',
			'color_subfooter_link' => '#926ed4',
			'color_subfooter_link_hover' => '#ffc80a',
			'color_footer_bg' => '#222',
			'color_footer_bg_alt' => '#333',
			'color_footer_border' => '#444',
			'color_footer_text' => '#dedede',
			'color_footer_link' => '#926ed4',
			'color_footer_link_hover' => '#ffc80a',
		),
	),
	array(
		'title' => __( 'White Alizarin', 'us' ),
		'values' => array(
			'color_body_bg' => '#fe4641',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#444',
			'color_header_middle_text_hover' => '#fda527',
			'color_chrome_toolbar' => '#fe4641',
			'color_header_top_bg' => '#fe4641',
			'color_header_top_text' => 'rgba(255,255,255,0.75)',
			'color_header_top_text_hover' => '#fff',
			'color_header_bottom_bg' => '#fe4641',
			'color_header_bottom_text' => 'rgba(255,255,255,0.75)',
			'color_header_bottom_text_hover' => '#fff',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fda527',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f5f5f5',
			'color_content_border' => '#e5e5e5',
			'color_content_heading' => '#222',
			'color_content_text' => '#444',
			'color_content_link' => '#fe4641',
			'color_content_link_hover' => '#fda527',
			'color_content_primary' => '#fe4641',
			'color_content_secondary' => '#fda527',
			'color_content_faded' => '#999',
			'color_alt_content_bg' => '#f5f5f5',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#ddd',
			'color_alt_content_heading' => '#222',
			'color_alt_content_text' => '#444',
			'color_alt_content_link' => '#fe4641',
			'color_alt_content_link_hover' => '#fda527',
			'color_alt_content_primary' => '#fe4641',
			'color_alt_content_secondary' => '#fda527',
			'color_alt_content_faded' => '#999',
			'color_subfooter_bg' => '#252525',
			'color_subfooter_bg_alt' => '#1c1c1c',
			'color_subfooter_border' => '#333',
			'color_subfooter_text' => '#999',
			'color_subfooter_link' => '#ddd',
			'color_subfooter_link_hover' => '#fda527',
			'color_footer_bg' => '#181818',
			'color_footer_bg_alt' => '#252525',
			'color_footer_border' => '#252525',
			'color_footer_text' => '#666',
			'color_footer_link' => '#aaa',
			'color_footer_link_hover' => '#fda527',
		),
	),
	array(
		'title' => __( 'White Sand', 'us' ),
		'values' => array(
			'color_body_bg' => '#f2f2f0',

			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#423b38',
			'color_header_middle_text_hover' => '#daa48a',
			'color_chrome_toolbar' => '#f2f2f0',
			'color_header_top_bg' => '#f2f2f0',
			'color_header_top_text' => '#8f8b88',
			'color_header_top_text_hover' => '#daa48a',
			'color_header_bottom_bg' => '#f2f2f0',
			'color_header_bottom_text' => '#8f8b88',
			'color_header_bottom_text_hover' => '#daa48a',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',

			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f2f2f0',
			'color_content_border' => '#e8e5e1',
			'color_content_heading' => '#21201e',
			'color_content_text' => '#423b38',
			'color_content_link' => '#daa48a',
			'color_content_link_hover' => '#423b38',
			'color_content_primary' => '#daa48a',
			'color_content_secondary' => '#423b38',
			'color_content_faded' => '#8f8b88',

			'color_alt_content_bg' => '#f2f2f0',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#e8e5e1',
			'color_alt_content_heading' => '#21201e',
			'color_alt_content_text' => '#423b38',
			'color_alt_content_link' => '#daa48a',
			'color_alt_content_link_hover' => '#423b38',
			'color_alt_content_primary' => '#daa48a',
			'color_alt_content_secondary' => '#423b38',
			'color_alt_content_faded' => '#8f8b88',

			'color_subfooter_bg' => '#423b38',
			'color_subfooter_bg_alt' => '#21201e',
			'color_subfooter_border' => '#4d4a49',
			'color_subfooter_text' => '#8f8b88',
			'color_subfooter_link' => '#ccc9c8',
			'color_subfooter_link_hover' => '#fff',

			'color_footer_bg' => '#423b38',
			'color_footer_bg_alt' => '#21201e',
			'color_footer_border' => '#4d4a49',
			'color_footer_text' => '#8f8b88',
			'color_footer_link' => '#ccc9c8',
			'color_footer_link_hover' => '#fff',
		),
	),
	array(
		'title' => __( 'White Royal', 'us' ),
		'values' => array(
			'color_body_bg' => '#301c2a',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#66525f',
			'color_header_middle_text_hover' => '#f4a641',
			'color_chrome_toolbar' => '#921245',
			'color_header_top_bg' => '#921245',
			'color_header_top_text' => 'rgba(255,255,255,0.75)',
			'color_header_top_text_hover' => '#fff',
			'color_header_bottom_bg' => '#921245',
			'color_header_bottom_text' => 'rgba(255,255,255,0.75)',
			'color_header_bottom_text_hover' => '#fff',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#f4a641',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f5f5f5',
			'color_content_border' => '#ebe6e9',
			'color_content_heading' => '#442b3d',
			'color_content_text' => '#66525f',
			'color_content_link' => '#f4a641',
			'color_content_link_hover' => '#921245',
			'color_content_primary' => '#f4a641',
			'color_content_secondary' => '#921245',
			'color_content_faded' => '#b39fac',
			'color_alt_content_bg' => '#f5f5f5',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#ded9dc',
			'color_alt_content_heading' => '#442b3d',
			'color_alt_content_text' => '#66525f',
			'color_alt_content_link' => '#f4a641',
			'color_alt_content_link_hover' => '#921245',
			'color_alt_content_primary' => '#f4a641',
			'color_alt_content_secondary' => '#921245',
			'color_alt_content_faded' => '#b39fac',
			'color_subfooter_bg' => '#301c2a',
			'color_subfooter_bg_alt' => '#442b3d',
			'color_subfooter_border' => '#442b3d',
			'color_subfooter_text' => '#b8a5b2',
			'color_subfooter_link' => '#f4a641',
			'color_subfooter_link_hover' => '#fff',
			'color_footer_bg' => '#301c2a',
			'color_footer_bg_alt' => '#442b3d',
			'color_footer_border' => '#442b3d',
			'color_footer_text' => '#b8a5b2',
			'color_footer_link' => '#f4a641',
			'color_footer_link_hover' => '#fff',
		),
	),
	array(
		'title' => __( 'Light Tangerine', 'us' ),
		'values' => array(
			'color_body_bg' => '#e1e4e5',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#25282b',
			'color_header_middle_text_hover' => '#ff5722',
			'color_chrome_toolbar' => '#fff',
			'color_header_top_bg' => '#f2f4f5',
			'color_header_top_text' => '#949799',
			'color_header_top_text_hover' => '#ff5722',
			'color_header_bottom_bg' => '#f2f4f5',
			'color_header_bottom_text' => '#949799',
			'color_header_bottom_text_hover' => '#ff5722',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#ff5722',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f2f4f5',
			'color_content_border' => '#e1e4e5',
			'color_content_heading' => '#25282b',
			'color_content_text' => '#4f5459',
			'color_content_link' => '#ff5722',
			'color_content_link_hover' => '#00bcd4',
			'color_content_primary' => '#ff5722',
			'color_content_secondary' => '#00bcd4',
			'color_content_faded' => '#949799',
			'color_alt_content_bg' => '#f2f4f5',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#e1e4e5',
			'color_alt_content_heading' => '#25282b',
			'color_alt_content_text' => '#4f5459',
			'color_alt_content_link' => '#ff5722',
			'color_alt_content_link_hover' => '#00bcd4',
			'color_alt_content_primary' => '#ff5722',
			'color_alt_content_secondary' => '#00bcd4',
			'color_alt_content_faded' => '#949799',
			'color_subfooter_bg' => '#25282b',
			'color_subfooter_bg_alt' => '#1c1f21',
			'color_subfooter_border' => '#35383b',
			'color_subfooter_text' => '#8e9194',
			'color_subfooter_link' => '#c2c4c5',
			'color_subfooter_link_hover' => '#fff',
			'color_footer_bg' => '#1c1f21',
			'color_footer_bg_alt' => '#25282b',
			'color_footer_border' => '#35383b',
			'color_footer_text' => '#8e9194',
			'color_footer_link' => '#c2c4c5',
			'color_footer_link_hover' => '#fff',
		),
	),
	array(
		'title' => __( 'White Yellow', 'us' ),
		'values' => array(
			'color_body_bg' => '#f2f1f0',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#333',
			'color_header_middle_text_hover' => '#ffa633',
			'color_chrome_toolbar' => '#f6f6f6',
			'color_header_top_bg' => '#f6f6f6',
			'color_header_top_text' => '#666',
			'color_header_top_text_hover' => '#ffa633',
			'color_header_bottom_bg' => '#f6f6f6',
			'color_header_bottom_text' => '#666',
			'color_header_bottom_text_hover' => '#ffa633',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#ffa633',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f6f6f6',
			'color_content_border' => '#ebebeb',
			'color_content_heading' => '#000',
			'color_content_text' => '#333',
			'color_content_link' => '#ffa633',
			'color_content_link_hover' => '#000',
			'color_content_primary' => '#ffa633',
			'color_content_secondary' => '#333',
			'color_content_faded' => '#999',
			'color_alt_content_bg' => '#f6f6f6',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#e5e5e5',
			'color_alt_content_heading' => '#000',
			'color_alt_content_text' => '#333',
			'color_alt_content_link' => '#ffa633',
			'color_alt_content_link_hover' => '#000',
			'color_alt_content_primary' => '#ffa633',
			'color_alt_content_secondary' => '#333',
			'color_alt_content_faded' => '#999',
			'color_subfooter_bg' => '#f6f6f6',
			'color_subfooter_bg_alt' => '#fff',
			'color_subfooter_border' => '#e2e2e2',
			'color_subfooter_text' => '#666',
			'color_subfooter_link' => '#ffa633',
			'color_subfooter_link_hover' => '#000',
			'color_footer_bg' => '#fff',
			'color_footer_bg_alt' => '#f6f6f6',
			'color_footer_border' => '#ebebeb',
			'color_footer_text' => '#999',
			'color_footer_link' => '#666',
			'color_footer_link_hover' => '#ffa633',
		),
	),
	array(
		'title' => __( 'White Blue', 'us' ),
		'values' => array(
			'color_body_bg' => '#eee',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#333',
			'color_header_middle_text_hover' => '#1b98e0',
			'color_chrome_toolbar' => '#f5f5f5',
			'color_header_top_bg' => '#f5f5f5',
			'color_header_top_text' => '#777',
			'color_header_top_text_hover' => '#1b98e0',
			'color_header_bottom_bg' => '#f5f5f5',
			'color_header_bottom_text' => '#777',
			'color_header_bottom_text_hover' => '#1b98e0',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f2f2f2',
			'color_content_border' => '#e5e5e5',
			'color_content_heading' => '#333',
			'color_content_text' => '#333',
			'color_content_link' => '#1b98e0',
			'color_content_link_hover' => '#004e7a',
			'color_content_primary' => '#1b98e0',
			'color_content_secondary' => '#004e7a',
			'color_content_faded' => '#999',
			'color_alt_content_bg' => '#f2f2f2',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#ddd',
			'color_alt_content_heading' => '#333',
			'color_alt_content_text' => '#333',
			'color_alt_content_link' => '#1b98e0',
			'color_alt_content_link_hover' => '#004e7a',
			'color_alt_content_primary' => '#1b98e0',
			'color_alt_content_secondary' => '#004e7a',
			'color_alt_content_faded' => '#999',
			'color_subfooter_bg' => '#333',
			'color_subfooter_bg_alt' => '#292929',
			'color_subfooter_border' => '#444',
			'color_subfooter_text' => '#999',
			'color_subfooter_link' => '#e5e5e5',
			'color_subfooter_link_hover' => '#1b98e0',
			'color_footer_bg' => '#fff',
			'color_footer_bg_alt' => '#f2f2f2',
			'color_footer_border' => '#e5e5e5',
			'color_footer_text' => '#777',
			'color_footer_link' => '#1b98e0',
			'color_footer_link_hover' => '#004e7a',
		),
	),
	array(
		'title' => __( 'Black & White', 'us' ),
		'values' => array(
			'color_body_bg' => '#fff',
			'color_header_middle_bg' => '#fff',
			'color_header_middle_text' => '#333',
			'color_header_middle_text_hover' => '#000',
			'color_chrome_toolbar' => '#f3f3f3',
			'color_header_top_bg' => '#f3f3f3',
			'color_header_top_text' => '#333',
			'color_header_top_text_hover' => '#000',
			'color_header_bottom_bg' => '#fff',
			'color_header_bottom_text' => '#333',
			'color_header_bottom_text_hover' => '#000',
			'color_header_transparent_text' => 'rgba(255,255,255,0.66)',
			'color_header_transparent_text_hover' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f3f3f3',
			'color_content_border' => '#ddd',
			'color_content_heading' => '#000',
			'color_content_text' => '#333',
			'color_content_link' => '#000',
			'color_content_link_hover' => '#000',
			'color_content_primary' => '#000',
			'color_content_secondary' => '#333',
			'color_content_faded' => '#999',
			'color_alt_content_bg' => '#333',
			'color_alt_content_bg_alt' => '#000',
			'color_alt_content_border' => '#444',
			'color_alt_content_heading' => '#fff',
			'color_alt_content_text' => '#999',
			'color_alt_content_link' => '#fff',
			'color_alt_content_link_hover' => '#fff',
			'color_alt_content_primary' => '#fff',
			'color_alt_content_secondary' => '#f3f3f3',
			'color_alt_content_faded' => '#666',
			'color_subfooter_bg' => '#fff',
			'color_subfooter_bg_alt' => '#f3f3f3',
			'color_subfooter_border' => '#ddd',
			'color_subfooter_text' => '#999',
			'color_subfooter_link' => '#000',
			'color_subfooter_link_hover' => '#000',
			'color_footer_bg' => '#fff',
			'color_footer_bg_alt' => '#f3f3f3',
			'color_footer_border' => '#ddd',
			'color_footer_text' => '#999',
			'color_footer_link' => '#000',
			'color_footer_link_hover' => '#000',
		),
	),
	array(
		'title' => __( 'Material Design', 'us' ),
		'values' => array(
			'color_body_bg' => '#e0e0e0',
			'color_header_middle_bg' => '#7049ba',
			'color_header_middle_text' => '#fff',
			'color_header_middle_text_hover' => '#fff',
			'color_chrome_toolbar' => '#7049ba',
			'color_header_top_bg' => '#6039a8',
			'color_header_top_text' => '#c8b8e5',
			'color_header_top_text_hover' => '#fff',
			'color_header_bottom_bg' => '#6039a8',
			'color_header_bottom_text' => '#c8b8e5',
			'color_header_bottom_text_hover' => '#fff',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f5f5f5',
			'color_content_border' => '#e0e0e0',
			'color_content_heading' => '#212121',
			'color_content_text' => '#424242',
			'color_content_link' => '#7049ba',
			'color_content_link_hover' => '#ffb03a',
			'color_content_primary' => '#7049ba',
			'color_content_secondary' => '#ffb03a',
			'color_content_faded' => '#9e9e9e',
			'color_alt_content_bg' => '#f5f5f5',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#e0e0e0',
			'color_alt_content_heading' => '#212121',
			'color_alt_content_text' => '#424242',
			'color_alt_content_link' => '#7049ba',
			'color_alt_content_link_hover' => '#ffb03a',
			'color_alt_content_primary' => '#7049ba',
			'color_alt_content_secondary' => '#ffb03a',
			'color_alt_content_faded' => '#9e9e9e',
			'color_subfooter_bg' => '#212121',
			'color_subfooter_bg_alt' => '#292929',
			'color_subfooter_border' => '#333',
			'color_subfooter_text' => '#9e9e9e',
			'color_subfooter_link' => '#9e9e9e',
			'color_subfooter_link_hover' => '#ffb03a',
			'color_footer_bg' => '#111',
			'color_footer_bg_alt' => '#212121',
			'color_footer_border' => '#292929',
			'color_footer_text' => '#9e9e9e',
			'color_footer_link' => '#9e9e9e',
			'color_footer_link_hover' => '#ffb03a',
		),
	),
	array(
		'title' => __( 'Sunny Cocktail', 'us' ),
		'values' => array(
			'color_body_bg' => '#e5e5e5',
			'color_header_middle_bg' => '#ffb300',
			'color_header_middle_text' => '#fff',
			'color_header_middle_text_hover' => '#fff',
			'color_chrome_toolbar' => '#ffa000',
			'color_header_top_bg' => '#ffa000',
			'color_header_top_text' => '#ffecb3',
			'color_header_top_text_hover' => '#fff',
			'color_header_bottom_bg' => '#ffa000',
			'color_header_bottom_text' => '#ffecb3',
			'color_header_bottom_text_hover' => '#fff',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f6f6f6',
			'color_content_border' => '#e5e5e5',
			'color_content_heading' => '#212121',
			'color_content_text' => '#444',
			'color_content_link' => '#a939bd',
			'color_content_link_hover' => '#ffb300',
			'color_content_primary' => '#a939bd',
			'color_content_secondary' => '#ffb300',
			'color_content_faded' => '#999',
			'color_alt_content_bg' => '#f6f6f6',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#e5e5e5',
			'color_alt_content_heading' => '#212121',
			'color_alt_content_text' => '#444',
			'color_alt_content_link' => '#a939bd',
			'color_alt_content_link_hover' => '#ffb300',
			'color_alt_content_primary' => '#a939bd',
			'color_alt_content_secondary' => '#ffb300',
			'color_alt_content_faded' => '#999',
			'color_subfooter_bg' => '#212121',
			'color_subfooter_bg_alt' => '#292929',
			'color_subfooter_border' => '#333',
			'color_subfooter_text' => '#999',
			'color_subfooter_link' => '#ccc',
			'color_subfooter_link_hover' => '#ffb300',
			'color_footer_bg' => '#111',
			'color_footer_bg_alt' => '#212121',
			'color_footer_border' => '#292929',
			'color_footer_text' => '#999',
			'color_footer_link' => '#ccc',
			'color_footer_link_hover' => '#ffb300',
		),
	),
	array(
		'title' => __( 'Mild Ocean', 'us' ),
		'values' => array(
			'color_body_bg' => '#d7e0df',
			'color_header_middle_bg' => '#009688',
			'color_header_middle_text' => '#fff',
			'color_header_middle_text_hover' => '#fff',
			'color_chrome_toolbar' => '#00897b',
			'color_header_top_bg' => '#00897b',
			'color_header_top_text' => '#b2dfdb',
			'color_header_top_text_hover' => '#fff',
			'color_header_bottom_bg' => '#00897b',
			'color_header_bottom_text' => '#b2dfdb',
			'color_header_bottom_text_hover' => '#fff',
			'color_header_transparent_text' => '#b2dfdb',
			'color_header_transparent_text_hover' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f2f4f5',
			'color_content_border' => '#dadfe0',
			'color_content_heading' => '#212121',
			'color_content_text' => '#3f4544',
			'color_content_link' => '#00bfa5',
			'color_content_link_hover' => '#2196f3',
			'color_content_primary' => '#00bfa5',
			'color_content_secondary' => '#2196f3',
			'color_content_faded' => '#7f8a88',
			'color_alt_content_bg' => '#f2f4f5',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#dadfe0',
			'color_alt_content_heading' => '#212121',
			'color_alt_content_text' => '#3f4544',
			'color_alt_content_link' => '#00bfa5',
			'color_alt_content_link_hover' => '#2196f3',
			'color_alt_content_primary' => '#00bfa5',
			'color_alt_content_secondary' => '#2196f3',
			'color_alt_content_faded' => '#7f8a88',
			'color_subfooter_bg' => '#1d2625',
			'color_subfooter_bg_alt' => '#26302f',
			'color_subfooter_border' => '#2d3837',
			'color_subfooter_text' => '#7f8a88',
			'color_subfooter_link' => '#b2bfbe',
			'color_subfooter_link_hover' => '#2196f3',
			'color_footer_bg' => '#141a19',
			'color_footer_bg_alt' => '#1d2625',
			'color_footer_border' => '#26302f',
			'color_footer_text' => '#7f8a88',
			'color_footer_link' => '#b2bfbe',
			'color_footer_link_hover' => '#2196f3',
		),
	),
	array(
		'title' => __( 'Light Ocean', 'us' ),
		'values' => array(
			'color_body_bg' => '#87a8a5',
			'color_header_middle_bg' => '#738e96',
			'color_header_middle_text' => '#fff',
			'color_header_middle_text_hover' => '#b2dab5',
			'color_chrome_toolbar' => '#627c83',
			'color_header_top_bg' => '#627c83',
			'color_header_top_text' => '#d5dddf',
			'color_header_top_text_hover' => '#fff',
			'color_header_bottom_bg' => '#627c83',
			'color_header_bottom_text' => '#d5dddf',
			'color_header_bottom_text_hover' => '#fff',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#edf1f2',
			'color_content_border' => '#e1e5e8',
			'color_content_heading' => '#38505c',
			'color_content_text' => '#505c5f',
			'color_content_link' => '#9ebaa0',
			'color_content_link_hover' => '#aa9d88',
			'color_content_primary' => '#9ebaa0',
			'color_content_secondary' => '#aa9d88',
			'color_content_faded' => '#999c9f',
			'color_alt_content_bg' => '#edf1f2',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#d7dde0',
			'color_alt_content_heading' => '#38505c',
			'color_alt_content_text' => '#505c5f',
			'color_alt_content_link' => '#9ebaa0',
			'color_alt_content_link_hover' => '#aa9d88',
			'color_alt_content_primary' => '#9ebaa0',
			'color_alt_content_secondary' => '#aa9d88',
			'color_alt_content_faded' => '#999c9f',
			'color_subfooter_bg' => '#738e96',
			'color_subfooter_bg_alt' => '#627c83',
			'color_subfooter_border' => '#839da4',
			'color_subfooter_text' => '#d5dddf',
			'color_subfooter_link' => '#fff',
			'color_subfooter_link_hover' => '#fff',
			'color_footer_bg' => '#627c83',
			'color_footer_bg_alt' => '#526a70',
			'color_footer_border' => '#738e96',
			'color_footer_text' => '#bbc5c7',
			'color_footer_link' => '#d5dddf',
			'color_footer_link_hover' => '#fff',
		),
	),
	array(
		'title' => __( 'Nautical Knot', 'us' ),
		'values' => array(
			'color_body_bg' => '#2c3e50',
			'color_header_middle_bg' => '#2c3e50',
			'color_header_middle_text' => '#edf0f2',
			'color_header_middle_text_hover' => '#fc4349',
			'color_chrome_toolbar' => '#384b5f',
			'color_header_top_bg' => '#384b5f',
			'color_header_top_text' => '#ced6de',
			'color_header_top_text_hover' => '#fff',
			'color_header_bottom_bg' => '#384b5f',
			'color_header_bottom_text' => '#ced6de',
			'color_header_bottom_text_hover' => '#fff',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fc4349',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f2f4f5',
			'color_content_border' => '#e4e8eb',
			'color_content_heading' => '#2c3e50',
			'color_content_text' => '#46515c',
			'color_content_link' => '#43a9d1',
			'color_content_link_hover' => '#fc4349',
			'color_content_primary' => '#43a9d1',
			'color_content_secondary' => '#fc4349',
			'color_content_faded' => '#9aa7b5',
			'color_alt_content_bg' => '#f2f4f5',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#e3e6e8',
			'color_alt_content_heading' => '#2c3e50',
			'color_alt_content_text' => '#46515c',
			'color_alt_content_link' => '#43a9d1',
			'color_alt_content_link_hover' => '#fc4349',
			'color_alt_content_primary' => '#43a9d1',
			'color_alt_content_secondary' => '#fc4349',
			'color_alt_content_faded' => '#9aa7b5',
			'color_subfooter_bg' => '#2c3e50',
			'color_subfooter_bg_alt' => '#384b5f',
			'color_subfooter_border' => '#384b5f',
			'color_subfooter_text' => '#9aa7b5',
			'color_subfooter_link' => '#edf0f2',
			'color_subfooter_link_hover' => '#fc4349',
			'color_footer_bg' => '#384b5f',
			'color_footer_bg_alt' => '#2c3e50',
			'color_footer_border' => '#44586e',
			'color_footer_text' => '#9aa7b5',
			'color_footer_link' => '#edf0f2',
			'color_footer_link_hover' => '#fc4349',
		),
	),
	array(
		'title' => __( 'Red Modern', 'us' ),
		'values' => array(
			'color_body_bg' => '#2b2c36',
			'color_header_middle_bg' => '#2b2c36',
			'color_header_middle_text' => '#edf0f2',
			'color_header_middle_text_hover' => '#ff2b58',
			'color_chrome_toolbar' => '#2b2c36',
			'color_header_top_bg' => '#2b2c36',
			'color_header_top_text' => '#d3d8db',
			'color_header_top_text_hover' => '#fff',
			'color_header_bottom_bg' => '#2b2c36',
			'color_header_bottom_text' => '#d3d8db',
			'color_header_bottom_text_hover' => '#fff',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#ff2b58',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#f2f4f5',
			'color_content_border' => '#dce0e3',
			'color_content_heading' => '#2b2c36',
			'color_content_text' => '#2b2c36',
			'color_content_link' => '#ff2b58',
			'color_content_link_hover' => '#6b748b',
			'color_content_primary' => '#ff2b58',
			'color_content_secondary' => '#6b748b',
			'color_content_faded' => '#9698a3',
			'color_alt_content_bg' => '#2b2c36',
			'color_alt_content_bg_alt' => '#363845',
			'color_alt_content_border' => '#4e5663',
			'color_alt_content_heading' => '#fff',
			'color_alt_content_text' => '#f2f4f5',
			'color_alt_content_link' => '#ff2b58',
			'color_alt_content_link_hover' => '#6b748b',
			'color_alt_content_primary' => '#ff2b58',
			'color_alt_content_secondary' => '#6b748b',
			'color_alt_content_faded' => '#9698a3',
			'color_subfooter_bg' => '#2b2c36',
			'color_subfooter_bg_alt' => '#363845',
			'color_subfooter_border' => '#4e5663',
			'color_subfooter_text' => '#9698a3',
			'color_subfooter_link' => '#fff',
			'color_subfooter_link_hover' => '#ff2b58',
			'color_footer_bg' => '#2b2c36',
			'color_footer_bg_alt' => '#363845',
			'color_footer_border' => '#4e5663',
			'color_footer_text' => '#9698a3',
			'color_footer_link' => '#fff',
			'color_footer_link_hover' => '#ff2b58',
		),
	),
	array(
		'title' => __( 'Midnight Red', 'us' ),
		'values' => array(
			'color_body_bg' => '#e3e6e8',
			'color_header_middle_bg' => '#363b3f',
			'color_header_middle_text' => '#fff',
			'color_header_middle_text_hover' => '#e14d43',
			'color_chrome_toolbar' => '#25282b',
			'color_header_top_bg' => '#25282b',
			'color_header_top_text' => '#c2c4c5',
			'color_header_top_text_hover' => '#e14d43',
			'color_header_bottom_bg' => '#25282b',
			'color_header_bottom_text' => '#c2c4c5',
			'color_header_bottom_text_hover' => '#e14d43',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#edf0f2',
			'color_content_border' => '#e1e5e8',
			'color_content_heading' => '#25282b',
			'color_content_text' => '#363b3f',
			'color_content_link' => '#e14d43',
			'color_content_link_hover' => '#69a8bb',
			'color_content_primary' => '#e14d43',
			'color_content_secondary' => '#69a8bb',
			'color_content_faded' => '#999c9f',
			'color_alt_content_bg' => '#edf0f2',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#d7dde0',
			'color_alt_content_heading' => '#25282b',
			'color_alt_content_text' => '#363b3f',
			'color_alt_content_link' => '#e14d43',
			'color_alt_content_link_hover' => '#69a8bb',
			'color_alt_content_primary' => '#e14d43',
			'color_alt_content_secondary' => '#69a8bb',
			'color_alt_content_faded' => '#999c9f',
			'color_subfooter_bg' => '#363b3f',
			'color_subfooter_bg_alt' => '#2f3438',
			'color_subfooter_border' => '#494e52',
			'color_subfooter_text' => '#999c9f',
			'color_subfooter_link' => '#c2c4c5',
			'color_subfooter_link_hover' => '#69a8bb',
			'color_footer_bg' => '#25282b',
			'color_footer_bg_alt' => '#2f3438',
			'color_footer_border' => '#363b3f',
			'color_footer_text' => '#7a7f83',
			'color_footer_link' => '#c2c4c5',
			'color_footer_link_hover' => '#69a8bb',
		),
	),
	array(
		'title' => __( 'Stylish Cyan', 'us' ),
		'values' => array(
			'color_body_bg' => '#ddd',
			'color_header_middle_bg' => '#1a1a1a',
			'color_header_middle_text' => '#ddd',
			'color_header_middle_text_hover' => '#32beeb',
			'color_chrome_toolbar' => '#222',
			'color_header_top_bg' => '#222',
			'color_header_top_text' => '#999',
			'color_header_top_text_hover' => '#32beeb',
			'color_header_bottom_bg' => '#222',
			'color_header_bottom_text' => '#999',
			'color_header_bottom_text_hover' => '#32beeb',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#32beeb',
			'color_content_bg' => '#fff',
			'color_content_bg_alt' => '#edf1f2',
			'color_content_border' => '#e1e5e8',
			'color_content_heading' => '#222',
			'color_content_text' => '#444',
			'color_content_link' => '#32beeb',
			'color_content_link_hover' => '#666',
			'color_content_primary' => '#32beeb',
			'color_content_secondary' => '#666',
			'color_content_faded' => '#999c9f',
			'color_alt_content_bg' => '#edf1f2',
			'color_alt_content_bg_alt' => '#fff',
			'color_alt_content_border' => '#d7dde0',
			'color_alt_content_heading' => '#222',
			'color_alt_content_text' => '#444',
			'color_alt_content_link' => '#32beeb',
			'color_alt_content_link_hover' => '#666',
			'color_alt_content_primary' => '#32beeb',
			'color_alt_content_secondary' => '#666',
			'color_alt_content_faded' => '#999c9f',
			'color_subfooter_bg' => '#1a1a1a',
			'color_subfooter_bg_alt' => '#222',
			'color_subfooter_border' => '#333',
			'color_subfooter_text' => '#777',
			'color_subfooter_link' => '#ccc',
			'color_subfooter_link_hover' => '#32beeb',
			'color_footer_bg' => '#222',
			'color_footer_bg_alt' => '#1a1a1a',
			'color_footer_border' => '#333',
			'color_footer_text' => '#666',
			'color_footer_link' => '#bbb',
			'color_footer_link_hover' => '#32beeb',
		),
	),
	array(
		'title' => __( 'Coffee Shop', 'us' ),
		'values' => array(
			'color_body_bg' => '#59524c',
			'color_header_middle_bg' => '#59524c',
			'color_header_middle_text' => '#fff',
			'color_header_middle_text_hover' => '#c7a589',
			'color_chrome_toolbar' => '#46403c',
			'color_header_top_bg' => '#46403c',
			'color_header_top_text' => '#cdcbc9',
			'color_header_top_text_hover' => '#c7a589',
			'color_header_bottom_bg' => '#46403c',
			'color_header_bottom_text' => '#cdcbc9',
			'color_header_bottom_text_hover' => '#c7a589',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_content_bg' => '#f2f1f0',
			'color_content_bg_alt' => '#fff',
			'color_content_border' => '#e0dedc',
			'color_content_heading' => '#46403c',
			'color_content_text' => '#46403c',
			'color_content_link' => '#c7a589',
			'color_content_link_hover' => '#9ea476',
			'color_content_primary' => '#c7a589',
			'color_content_secondary' => '#9ea476',
			'color_content_faded' => '#979699',
			'color_alt_content_bg' => '#e5e3e1',
			'color_alt_content_bg_alt' => '#f2f1f0',
			'color_alt_content_border' => '#d6d4d2',
			'color_alt_content_heading' => '#46403c',
			'color_alt_content_text' => '#46403c',
			'color_alt_content_link' => '#c7a589',
			'color_alt_content_link_hover' => '#9ea476',
			'color_alt_content_primary' => '#c7a589',
			'color_alt_content_secondary' => '#9ea476',
			'color_alt_content_faded' => '#979699',
			'color_subfooter_bg' => '#59524c',
			'color_subfooter_bg_alt' => '#46403c',
			'color_subfooter_border' => '#69625c',
			'color_subfooter_text' => '#b1a9a2',
			'color_subfooter_link' => '#ddd6d0',
			'color_subfooter_link_hover' => '#fff',
			'color_footer_bg' => '#46403c',
			'color_footer_bg_alt' => '#59524c',
			'color_footer_border' => '#69625c',
			'color_footer_text' => '#98918a',
			'color_footer_link' => '#b1a9a2',
			'color_footer_link_hover' => '#fff',
		),
	),
	array(
		'title' => __( 'Retro Package', 'us' ),
		'values' => array(
			'color_body_bg' => '#d9cfb8',
			'color_header_middle_bg' => '#4e4540',
			'color_header_middle_text' => '#f7f4ed',
			'color_header_middle_text_hover' => '#47bbca',
			'color_chrome_toolbar' => '#3d3632',
			'color_header_top_bg' => '#3d3632',
			'color_header_top_text' => '#f7f4ed',
			'color_header_top_text_hover' => '#47bbca',
			'color_header_bottom_bg' => '#3d3632',
			'color_header_bottom_text' => '#f7f4ed',
			'color_header_bottom_text_hover' => '#47bbca',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_content_bg' => '#f7f4ed',
			'color_content_bg_alt' => '#edeae4',
			'color_content_border' => '#e5e1d7',
			'color_content_heading' => '#4e4540',
			'color_content_text' => '#4e4540',
			'color_content_link' => '#f26c51',
			'color_content_link_hover' => '#47bbca',
			'color_content_primary' => '#f26c51',
			'color_content_secondary' => '#47bbca',
			'color_content_faded' => '#99948a',
			'color_alt_content_bg' => '#edeae4',
			'color_alt_content_bg_alt' => '#f7f4ed',
			'color_alt_content_border' => '#dbd5ca',
			'color_alt_content_heading' => '#4e4540',
			'color_alt_content_text' => '#4e4540',
			'color_alt_content_link' => '#f26c51',
			'color_alt_content_link_hover' => '#47bbca',
			'color_alt_content_primary' => '#f26c51',
			'color_alt_content_secondary' => '#47bbca',
			'color_alt_content_faded' => '#99948a',
			'color_subfooter_bg' => '#4e4540',
			'color_subfooter_bg_alt' => '#3d3632',
			'color_subfooter_border' => '#5c524d',
			'color_subfooter_text' => '#ada29a',
			'color_subfooter_link' => '#f26c51',
			'color_subfooter_link_hover' => '#47bbca',
			'color_footer_bg' => '#3d3632',
			'color_footer_bg_alt' => '#4e4540',
			'color_footer_border' => '#5c524d',
			'color_footer_text' => '#978f8a',
			'color_footer_link' => '#c4b8b1',
			'color_footer_link_hover' => '#47bbca',
		),
	),
	array(
		'title' => __( 'Twilight', 'us' ),
		'values' => array(
			'color_body_bg' => '#38424a',
			'color_header_middle_bg' => '#21282e',
			'color_header_middle_text' => '#b0b6be',
			'color_header_middle_text_hover' => '#71a7d3',
			'color_chrome_toolbar' => '#1c2126',
			'color_header_top_bg' => '#1c2126',
			'color_header_top_text' => '#b0b6be',
			'color_header_top_text_hover' => '#937cbf',
			'color_header_bottom_bg' => '#1c2126',
			'color_header_bottom_text' => '#b0b6be',
			'color_header_bottom_text_hover' => '#937cbf',
			'color_header_transparent_text' => '#dadfe6',
			'color_header_transparent_text_hover' => '#fff',
			'color_content_bg' => '#21282e',
			'color_content_bg_alt' => '#1c2126',
			'color_content_border' => '#303940',
			'color_content_heading' => '#d0d5db',
			'color_content_text' => '#bfc4c9',
			'color_content_link' => '#71a7d3',
			'color_content_link_hover' => '#937cbf',
			'color_content_primary' => '#71a7d3',
			'color_content_secondary' => '#937cbf',
			'color_content_faded' => '#757b83',
			'color_alt_content_bg' => '#1c2126',
			'color_alt_content_bg_alt' => '#21282e',
			'color_alt_content_border' => '#303940',
			'color_alt_content_heading' => '#d0d5db',
			'color_alt_content_text' => '#bfc4c9',
			'color_alt_content_link' => '#71a7d3',
			'color_alt_content_link_hover' => '#937cbf',
			'color_alt_content_primary' => '#71a7d3',
			'color_alt_content_secondary' => '#937cbf',
			'color_alt_content_faded' => '#757b83',
			'color_subfooter_bg' => '#1c2126',
			'color_subfooter_bg_alt' => '#21282e',
			'color_subfooter_border' => '#303940',
			'color_subfooter_text' => '#939aa2',
			'color_subfooter_link' => '#ccd0d4',
			'color_subfooter_link_hover' => '#937cbf',
			'color_footer_bg' => '#21282e',
			'color_footer_bg_alt' => '#1c2126',
			'color_footer_border' => '#303940',
			'color_footer_text' => '#939aa2',
			'color_footer_link' => '#ccd0d4',
			'color_footer_link_hover' => '#937cbf',
		),
	),
	array(
		'title' => __( 'Grey Turquoise', 'us' ),
		'values' => array(
			'color_body_bg' => '#222',
			'color_header_middle_bg' => '#444',
			'color_header_middle_text' => '#ccc',
			'color_header_middle_text_hover' => '#1abc9c',
			'color_chrome_toolbar' => '#393939',
			'color_header_top_bg' => '#393939',
			'color_header_top_text' => '#ccc',
			'color_header_top_text_hover' => '#1abc9c',
			'color_header_bottom_bg' => '#393939',
			'color_header_bottom_text' => '#ccc',
			'color_header_bottom_text_hover' => '#1abc9c',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#1abc9c',
			'color_content_bg' => '#444',
			'color_content_bg_alt' => '#393939',
			'color_content_border' => '#595959',
			'color_content_heading' => '#fff',
			'color_content_text' => '#ccc',
			'color_content_link' => '#1abc9c',
			'color_content_link_hover' => '#fab908',
			'color_content_primary' => '#1abc9c',
			'color_content_secondary' => '#fab908',
			'color_content_faded' => '#888',
			'color_alt_content_bg' => '#393939',
			'color_alt_content_bg_alt' => '#444',
			'color_alt_content_border' => '#444',
			'color_alt_content_heading' => '#fff',
			'color_alt_content_text' => '#ccc',
			'color_alt_content_link' => '#1abc9c',
			'color_alt_content_link_hover' => '#fab908',
			'color_alt_content_primary' => '#1abc9c',
			'color_alt_content_secondary' => '#fab908',
			'color_alt_content_faded' => '#888',
			'color_subfooter_bg' => '#303030',
			'color_subfooter_bg_alt' => '#282828',
			'color_subfooter_border' => '#444',
			'color_subfooter_text' => '#808080',
			'color_subfooter_link' => '#ccc',
			'color_subfooter_link_hover' => '#fab908',
			'color_footer_bg' => '#222',
			'color_footer_bg_alt' => '#282828',
			'color_footer_border' => '#333',
			'color_footer_text' => '#666',
			'color_footer_link' => '#aaa',
			'color_footer_link_hover' => '#fab908',
		),
	),
	array(
		'title' => __( 'City Hunter', 'us' ),
		'values' => array(
			'color_body_bg' => '#242d39',
			'color_header_middle_bg' => '#323f4f',
			'color_header_middle_text' => '#e8eff5',
			'color_header_middle_text_hover' => '#fd6861',
			'color_chrome_toolbar' => '#242d39',
			'color_header_top_bg' => '#242d39',
			'color_header_top_text' => '#b8c1cc',
			'color_header_top_text_hover' => '#8ed8f5',
			'color_header_bottom_bg' => '#242d39',
			'color_header_bottom_text' => '#b8c1cc',
			'color_header_bottom_text_hover' => '#8ed8f5',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#8ed8f5',
			'color_content_bg' => '#465568',
			'color_content_bg_alt' => '#323f4f',
			'color_content_border' => '#596b80',
			'color_content_heading' => '#fff',
			'color_content_text' => '#e8eff5',
			'color_content_link' => '#fd6861',
			'color_content_link_hover' => '#8ed8f5',
			'color_content_primary' => '#fd6861',
			'color_content_secondary' => '#8ed8f5',
			'color_content_faded' => '#7c8a97',
			'color_alt_content_bg' => '#323f4f',
			'color_alt_content_bg_alt' => '#465568',
			'color_alt_content_border' => '#465568',
			'color_alt_content_heading' => '#fff',
			'color_alt_content_text' => '#e8eff5',
			'color_alt_content_link' => '#fd6861',
			'color_alt_content_link_hover' => '#8ed8f5',
			'color_alt_content_primary' => '#fd6861',
			'color_alt_content_secondary' => '#8ed8f5',
			'color_alt_content_faded' => '#7c8a97',
			'color_subfooter_bg' => '#323f4f',
			'color_subfooter_bg_alt' => '#242d39',
			'color_subfooter_border' => '#414f61',
			'color_subfooter_text' => '#959eab',
			'color_subfooter_link' => '#cbcfd4',
			'color_subfooter_link_hover' => '#8ed8f5',
			'color_footer_bg' => '#242d39',
			'color_footer_bg_alt' => '#323f4f',
			'color_footer_border' => '#323f4f',
			'color_footer_text' => '#8a9099',
			'color_footer_link' => '#cbcfd4',
			'color_footer_link_hover' => '#8ed8f5',
		),
	),
	array(
		'title' => __( 'Black Gold', 'us' ),
		'values' => array(
			'color_body_bg' => '#2e2925',
			'color_header_middle_bg' => '#211e1b',
			'color_header_middle_text' => '#ccc4bc',
			'color_header_middle_text_hover' => '#f2ba66',
			'color_chrome_toolbar' => '#211e1b',
			'color_header_top_bg' => '#211e1b',
			'color_header_top_text' => '#ccc4bc',
			'color_header_top_text_hover' => '#fff',
			'color_header_bottom_bg' => '#211e1b',
			'color_header_bottom_text' => '#ccc4bc',
			'color_header_bottom_text_hover' => '#fff',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#f2ba66',
			'color_content_bg' => '#2e2925',
			'color_content_bg_alt' => '#211e1b',
			'color_content_border' => '#423c36',
			'color_content_heading' => '#fff',
			'color_content_text' => '#ccc4bc',
			'color_content_link' => '#f2ba66',
			'color_content_link_hover' => '#f2ba66',
			'color_content_primary' => '#f2ba66',
			'color_content_secondary' => '#f2ba66',
			'color_content_faded' => '#8c857e',
			'color_alt_content_bg' => '#211e1b',
			'color_alt_content_bg_alt' => '#2e2925',
			'color_alt_content_border' => '#423c36',
			'color_alt_content_heading' => '#fff',
			'color_alt_content_text' => '#ccc4bc',
			'color_alt_content_link' => '#f2ba66',
			'color_alt_content_link_hover' => '#f2ba66',
			'color_alt_content_primary' => '#f2ba66',
			'color_alt_content_secondary' => '#f2ba66',
			'color_alt_content_faded' => '#8c857e',
			'color_subfooter_bg' => '#211e1b',
			'color_subfooter_bg_alt' => '#2e2925',
			'color_subfooter_border' => '#423c36',
			'color_subfooter_text' => '#8c857e',
			'color_subfooter_link' => '#ccc4bc',
			'color_subfooter_link_hover' => '#f2ba66',
			'color_footer_bg' => '#211e1b',
			'color_footer_bg_alt' => '#2e2925',
			'color_footer_border' => '#423c36',
			'color_footer_text' => '#8c857e',
			'color_footer_link' => '#ccc4bc',
			'color_footer_link_hover' => '#f2ba66',
		),
	),
	array(
		'title' => __( 'Green Darkness', 'us' ),
		'values' => array(
			'color_body_bg' => '#0f0f0f',
			'color_header_middle_bg' => '#21b11e',
			'color_header_middle_text' => '#fff',
			'color_header_middle_text_hover' => '#fff',
			'color_chrome_toolbar' => '#1b9d17',
			'color_header_top_bg' => '#1b9d17',
			'color_header_top_text' => '#c8e6c9',
			'color_header_top_text_hover' => '#fff',
			'color_header_bottom_bg' => '#1b9d17',
			'color_header_bottom_text' => '#c8e6c9',
			'color_header_bottom_text_hover' => '#fff',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_content_bg' => '#262626',
			'color_content_bg_alt' => '#1d1d1d',
			'color_content_border' => '#393939',
			'color_content_heading' => '#eee',
			'color_content_text' => '#bbb',
			'color_content_link' => '#21b11e',
			'color_content_link_hover' => '#5676f1',
			'color_content_primary' => '#21b11e',
			'color_content_secondary' => '#5676f1',
			'color_content_faded' => '#777',
			'color_alt_content_bg' => '#262626',
			'color_alt_content_bg_alt' => '#1d1d1d',
			'color_alt_content_border' => '#393939',
			'color_alt_content_heading' => '#eee',
			'color_alt_content_text' => '#bbb',
			'color_alt_content_link' => '#21b11e',
			'color_alt_content_link_hover' => '#5676f1',
			'color_alt_content_primary' => '#21b11e',
			'color_alt_content_secondary' => '#5676f1',
			'color_alt_content_faded' => '#777',
			'color_subfooter_bg' => '#1d1d1d',
			'color_subfooter_bg_alt' => '#262626',
			'color_subfooter_border' => '#333',
			'color_subfooter_text' => '#bbb',
			'color_subfooter_link' => '#21b11e',
			'color_subfooter_link_hover' => '#5676f1',
			'color_footer_bg' => '#0f0f0f',
			'color_footer_bg_alt' => '#1d1d1d',
			'color_footer_border' => '#262626',
			'color_footer_text' => '#777',
			'color_footer_link' => '#bbb',
			'color_footer_link_hover' => '#5676f1',
		),
	),
	array(
		'title' => __( 'Wet Stone', 'us' ),
		'values' => array(
			'color_body_bg' => '#12171a',
			'color_header_middle_bg' => '#263238',
			'color_header_middle_text' => '#cfd8dc',
			'color_header_middle_text_hover' => '#fff',
			'color_chrome_toolbar' => '#12171a',
			'color_header_top_bg' => '#1b2327',
			'color_header_top_text' => '#b0bec5',
			'color_header_top_text_hover' => '#fff',
			'color_header_bottom_bg' => '#1b2327',
			'color_header_bottom_text' => '#b0bec5',
			'color_header_bottom_text_hover' => '#fff',
			'color_header_transparent_text' => '#fff',
			'color_header_transparent_text_hover' => '#fff',
			'color_content_bg' => '#37474f',
			'color_content_bg_alt' => '#263238',
			'color_content_border' => '#4f5d64',
			'color_content_heading' => '#fff',
			'color_content_text' => '#cfd8dc',
			'color_content_link' => '#80cbc4',
			'color_content_link_hover' => '#69aaf0',
			'color_content_primary' => '#80cbc4',
			'color_content_secondary' => '#69aaf0',
			'color_content_faded' => '#9ea8ad',
			'color_alt_content_bg' => '#263238',
			'color_alt_content_bg_alt' => '#37474f',
			'color_alt_content_border' => '#4f5d64',
			'color_alt_content_heading' => '#fff',
			'color_alt_content_text' => '#cfd8dc',
			'color_alt_content_link' => '#80cbc4',
			'color_alt_content_link_hover' => '#69aaf0',
			'color_alt_content_primary' => '#80cbc4',
			'color_alt_content_secondary' => '#69aaf0',
			'color_alt_content_faded' => '#9ea8ad',
			'color_subfooter_bg' => '#1b2327',
			'color_subfooter_bg_alt' => '#263238',
			'color_subfooter_border' => '#263238',
			'color_subfooter_text' => '#9ea8ad',
			'color_subfooter_link' => '#cfd8dc',
			'color_subfooter_link_hover' => '#69aaf0',
			'color_footer_bg' => '#12171a',
			'color_footer_bg_alt' => '#1b2327',
			'color_footer_border' => '#263238',
			'color_footer_text' => '#9ea8ad',
			'color_footer_link' => '#cfd8dc',
			'color_footer_link_hover' => '#69aaf0',
		),
	),
);
