<?php


namespace Elementor;

use Elementor\Widget_Base;

class Carousel_Widget extends Widget_Base {

    public function get_name() {
        return 'myCarousel-widget';
    }

    public function get_title() {
        return 'My Carousel Widget';
    }

    public function get_icon() {
        return 'eicon-nested-carousel';
    }

    public function get_categories() {
        return [ 'myew-for-elementor' ];
    }

    public function get_script_depends() {
        return [
            'my-addons-script'
        ];
    }

    protected function _register_controls() {
        // Onglet "Contenu"
        $this->start_controls_section(
            'carousel_icon_boxes_content_section',
            [
                'label' => __( 'Contenu', 'mon-domaine' ),
            ]
        );

        $repeater = new \Elementor\Repeater();

        // Contrôle pour choisir une icône d'Elementor
        $repeater->add_control(
            'icone_elementor',
            [
                'label' => __( 'Icône Elementor', 'mon-domaine' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'media_type' => 'image/svg+xml',
            ]
        );

        $repeater->add_control(
            'titre',
            [
                'label' => __( 'Titre', 'mon-domaine' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Titre', 'mon-domaine' ), // Titre par défaut
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'contenu',
            [
                'label' => __( 'Contenu', 'mon-domaine' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => __( 'Contenu de la boîte', 'mon-domaine' ), // Contenu par défaut
                'show_label' => false,
            ]
        );

        $this->add_control(
            'carousel_icon_boxes',
            [
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ titre }}}', // Champ utilisé pour afficher le titre dans l'éditeur
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_navigation',
            [
                'label' => esc_html__('Navigation', 'my_addons'),
            ]
        );

        $this->add_control(
            'prev_button_svg',
            [
                'label' => esc_html__('Previous Button SVG', 'my_addons'),
                'type' => Controls_Manager::MEDIA,
                'media_type' => 'image/svg+xml',
            ]
        );

        $this->add_control(
            'next_button_svg',
            [
                'label' => esc_html__('Next Button SVG', 'my_addons'),
                'type' => Controls_Manager::MEDIA,
                'media_type' => 'image/svg+xml',
            ]
        );

        $this->end_controls_section();


        // Onglet "Style"
        $this->start_controls_section(
            'carousel_icon_boxes_style_section',
            [
                'label' => __( 'Style', 'mon-domaine' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );



        // Contrôles pour les styles du titre (couleur du texte et typographie)
        $this->add_control(
            'titre_color',
            [
                'label' => __( 'Couleur du titre', 'mon-domaine' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333333',
                'selectors' => [
                    '{{WRAPPER}} .carousel__box .box__title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'titre_typography',
                'label' => __( 'Typographie du titre', 'mon-domaine' ),
                'selector' => '{{WRAPPER}} .carousel__box .box__title',
            ]
        );

        // Contrôles pour la taille de l'icône
        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __( 'Taille de l\'icône', 'mon-domaine' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'default' => [
                    'size' => 24,
                ],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel__img' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // Contrôles pour les styles du contenu (couleur du texte et typographie)
        $this->add_control(
            'contenu_color',
            [
                'label' => __( 'Couleur du contenu', 'mon-domaine' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#555555',
                'selectors' => [
                    '{{WRAPPER}} .carousel__box .box__content' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'contenu_typography',
                'label' => __( 'Typographie du contenu', 'mon-domaine' ),
                'selector' => '{{WRAPPER}} .carousel__box .box__content',
            ]
        );

        $this->end_controls_section();

        // Styles for splide__slide

        $this->start_controls_section(
            'section_style_slide',
            [
                'label' => __( 'Slide Styles', 'your-text-domain' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'slide_gap',
            [
                'label' => __( 'Gap', 'your-text-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .splide__slide' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_align_items',
            [
                'label' => __( 'Align Items', 'your-text-domain' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'flex-start' => __( 'Start', 'your-text-domain' ),
                    'center' => __( 'Center', 'your-text-domain' ),
                    'flex-end' => __( 'End', 'your-text-domain' ),
                    'stretch' => __( 'Stretch', 'your-text-domain' ),
                    'baseline' => __( 'Baseline', 'your-text-domain' ),
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .splide__slide' => 'align-items: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slide_padding',
            [
                'label' => __( 'Padding', 'your-text-domain' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .splide__slide' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_background',
            [
                'label' => __( 'Background Color', 'your-text-domain' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .splide__slide' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_space',
            [
                'label' => __( 'Espace entre contenus', 'your-text-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .splide__slide' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'slide_box_shadow',
                'label' => __( 'Box Shadow', 'your-text-domain' ),
                'selector' => '{{WRAPPER}} .splide__slide',
            ]
        );

        $this->add_control(
            'nav_color',
            [
                'label' => __( 'Navigation Color', 'mon-domaine' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .splide__arrow svg path' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'nav_margin',
            [
                'label' => __( 'Navigation Margin', 'mon-domaine' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .splide__arrows' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'nav_gap',
            [
                'label' => __( 'Navigation Gap', 'mon-domaine' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .splide__arrow + .splide__arrow' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // Add more controls for other styles (box-shadow, align-items, gap, etc.)

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        if ( ! empty( $settings['carousel_icon_boxes'] ) ) {
            ?>
            <style>
                .splide__arrow {
                    border-color: transparent;
                }

                .splide__arrow:hover {
                    border-color: <?php echo $this->get_settings_for_display('nav_color'); ?>;
                }

                @media (max-width: 1024px) {
                    .splide__arrow {
                        border-color: <?php echo $this->get_settings_for_display('nav_color'); ?>!important;
                    }
                }
            </style>
            <div class="container carousel_default">
                <section class="splide" id="carousel_default_<?=$this->get_id();?>" aria-label="Splide Basic HTML Example">
                    <?php
                    $prev_button_svg = $settings['prev_button_svg']['url'];
                    $next_button_svg = $settings['next_button_svg']['url'];
                    ?>
                    <div class="splide__arrows">
                        <button class="splide__arrow splide__arrow--prev">
                            <?php if(!empty($prev_button_svg)):?>
                                <?=file_get_contents($prev_button_svg)?>
                            <?php else:?>
                                <svg width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M9.99841 19.722C9.82006 19.5481 9.73089 19.3199 9.73089 19.0374C9.73089 18.7549 9.82006 18.5267 9.99841 18.3528L17.5557 10.9856H1.00318C0.713376 10.9856 0.473726 10.8933 0.284236 10.7085C0.0947452 10.5238 0 10.2902 0 10.0077C0 9.72515 0.0947452 9.49153 0.284236 9.30681C0.473726 9.12208 0.713376 9.02972 1.00318 9.02972H17.5557L9.99841 1.66251C9.82006 1.48865 9.73089 1.25503 9.73089 0.961649C9.73089 0.668265 9.82006 0.434644 9.99841 0.260786C10.1768 0.0869287 10.4108 0 10.7006 0C10.9904 0 11.2245 0.0869287 11.4029 0.260786L20.699 9.32311C20.8105 9.43177 20.8885 9.54043 20.9331 9.64909C20.9777 9.75775 21 9.87728 21 10.0077C21 10.1163 20.9777 10.2304 20.9331 10.35C20.8885 10.4695 20.8105 10.5836 20.699 10.6922L11.4029 19.7546C11.2245 19.9284 10.9904 20.0099 10.7006 19.999C10.4108 19.9882 10.1768 19.8958 9.99841 19.722Z" fill="<?=$settings['nav_color']?>"/>
                                </svg>
                            <?php endif;?>
                        </button>
                        <button class="splide__arrow splide__arrow--next">
                            <?php if(!empty($next_button_svg)):?>
                                <?=file_get_contents($next_button_svg)?>
                            <?php else:?>
                                <svg width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M9.99841 19.722C9.82006 19.5481 9.73089 19.3199 9.73089 19.0374C9.73089 18.7549 9.82006 18.5267 9.99841 18.3528L17.5557 10.9856H1.00318C0.713376 10.9856 0.473726 10.8933 0.284236 10.7085C0.0947452 10.5238 0 10.2902 0 10.0077C0 9.72515 0.0947452 9.49153 0.284236 9.30681C0.473726 9.12208 0.713376 9.02972 1.00318 9.02972H17.5557L9.99841 1.66251C9.82006 1.48865 9.73089 1.25503 9.73089 0.961649C9.73089 0.668265 9.82006 0.434644 9.99841 0.260786C10.1768 0.0869287 10.4108 0 10.7006 0C10.9904 0 11.2245 0.0869287 11.4029 0.260786L20.699 9.32311C20.8105 9.43177 20.8885 9.54043 20.9331 9.64909C20.9777 9.75775 21 9.87728 21 10.0077C21 10.1163 20.9777 10.2304 20.9331 10.35C20.8885 10.4695 20.8105 10.5836 20.699 10.6922L11.4029 19.7546C11.2245 19.9284 10.9904 20.0099 10.7006 19.999C10.4108 19.9882 10.1768 19.8958 9.99841 19.722Z" fill="<?=$settings['nav_color']?>"/>
                                </svg>
                            <?php endif;?>
                        </button>
                    </div>
                    <div class="splide__track">
                        <ul class="splide__list">
                            <?php foreach ( $settings['carousel_icon_boxes'] as $item ):?>
                                <?php
                                    $image = $item["icone_elementor"]["url"];
                                    $title = $item["titre"];
                                    $content = $item["contenu"];
                                ?>
                                <li class="splide__slide">
                                    <img src="<?=$image?>" alt="<?=$title?>" class="carousel__img">
                                    <div class="carousel__box">
                                        <div class="box__title"><?=$title?></div>
                                        <div class="box__content">
                                            <?=$content?>
                                        </div>
                                    </div>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </section>
            </div>
            <?php
        }
    }

    protected function _content_template() {
        ?>
        <div class="container carousel_default">
            <section class="splide" id="carousel_default" aria-label="Splide Basic HTML Example">
                <div class="splide__arrows">
                    <button class="splide__arrow splide__arrow--prev">
                        <# if ( settings.prev_button_svg.url ) { #>
                        <img src="{{ settings.prev_button_svg.url }}" alt="">
                        <# } else { #>
                        <svg width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M9.99841 19.722C9.82006 19.5481 9.73089 19.3199 9.73089 19.0374C9.73089 18.7549 9.82006 18.5267 9.99841 18.3528L17.5557 10.9856H1.00318C0.713376 10.9856 0.473726 10.8933 0.284236 10.7085C0.0947452 10.5238 0 10.2902 0 10.0077C0 9.72515 0.0947452 9.49153 0.284236 9.30681C0.473726 9.12208 0.713376 9.02972 1.00318 9.02972H17.5557L9.99841 1.66251C9.82006 1.48865 9.73089 1.25503 9.73089 0.961649C9.73089 0.668265 9.82006 0.434644 9.99841 0.260786C10.1768 0.0869287 10.4108 0 10.7006 0C10.9904 0 11.2245 0.0869287 11.4029 0.260786L20.699 9.32311C20.8105 9.43177 20.8885 9.54043 20.9331 9.64909C20.9777 9.75775 21 9.87728 21 10.0077C21 10.1163 20.9777 10.2304 20.9331 10.35C20.8885 10.4695 20.8105 10.5836 20.699 10.6922L11.4029 19.7546C11.2245 19.9284 10.9904 20.0099 10.7006 19.999C10.4108 19.9882 10.1768 19.8958 9.99841 19.722Z" fill="#B5ADA8"/>
                        </svg>
                        <# } #>
                    </button>
                    <button class="splide__arrow splide__arrow--next">
                        <# if ( settings.next_button_svg.url ) { #>
                        <img src="{{ settings.next_button_svg.url }}" alt="">
                        <# } else { #>
                        <svg width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M9.99841 19.722C9.82006 19.5481 9.73089 19.3199 9.73089 19.0374C9.73089 18.7549 9.82006 18.5267 9.99841 18.3528L17.5557 10.9856H1.00318C0.713376 10.9856 0.473726 10.8933 0.284236 10.7085C0.0947452 10.5238 0 10.2902 0 10.0077C0 9.72515 0.0947452 9.49153 0.284236 9.30681C0.473726 9.12208 0.713376 9.02972 1.00318 9.02972H17.5557L9.99841 1.66251C9.82006 1.48865 9.73089 1.25503 9.73089 0.961649C9.73089 0.668265 9.82006 0.434644 9.99841 0.260786C10.1768 0.0869287 10.4108 0 10.7006 0C10.9904 0 11.2245 0.0869287 11.4029 0.260786L20.699 9.32311C20.8105 9.43177 20.8885 9.54043 20.9331 9.64909C20.9777 9.75775 21 9.87728 21 10.0077C21 10.1163 20.9777 10.2304 20.9331 10.35C20.8885 10.4695 20.8105 10.5836 20.699 10.6922L11.4029 19.7546C11.2245 19.9284 10.9904 20.0099 10.7006 19.999C10.4108 19.9882 10.1768 19.8958 9.99841 19.722Z" fill="#B5ADA8"/>
                        </svg>
                        <# } #>
                    </button>
                </div>
                <div class="splide__track">
                    <ul class="splide__list">
                        <# _.each( settings.carousel_icon_boxes, function( item ) { #>
                        <li class="splide__slide">
                            <# if ( item.icone_elementor.url ) { #>
                            <img src="{{ item.icone_elementor.url }}" alt="">
                            <# } #>
                            <div class="carousel__box">
                                <div class="box__title">{{ item.titre }}</div>
                                <div class="box__content">{{ item.contenu }}</div>
                            </div>
                        </li>
                        <# }); #>
                    </ul>
                </div>
            </section>
        </div>
        <?php
    }




}


Plugin::instance()->widgets_manager->register_widget_type( new Carousel_Widget() );
