<?php
namespace Elementor;

use Elementor\Widget_Base;

class Card_Docteur_Widget extends Widget_Base {

    /**
     * Retrieve the widget name.
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'my_card_list';
    }

    /**
     * Retrieve the widget title.
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Liste Docteurs', 'my_addons' );
    }

    /**
     * Retrieve the widget icon.
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-posts-grid';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return ['myew-for-elementor'];
    }

    /**
     * Retrieve the widget control options.
     *
     * @return array Widget control options.
     */
    protected function _register_controls() {

        //Cards content

        $this->start_controls_section(
            'section_card_docteur',
            [
                'label' => __( 'Listes Docteurs', 'my_addons' ),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'doctor_name',
            [
                'label' => __( 'Doctor name', 'my_addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Doctor name', 'my_addons' ),
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__( 'Choose Image', 'my_addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'doctor_content',
            [
                'label' => __( 'Doctor Content', 'my_addons' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => '',
            ]
        );

        $this->add_control(
            'doctor',
            [
                'label' => __( 'Doctor', 'my_addons' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [],
                'title_field' => '{{{ doctor_name }}}',
            ]
        );

        $this->end_controls_section();

        //Cards Style

        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__( 'Style du cards', 'my_addons' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'style_card',
            [
                'label' => esc_html__( 'Style', 'my_addons' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'default',
                'options' => [
                    'default' => esc_html__( 'Default', 'my_addons' ),
                    'style1' => esc_html__( 'Style1', 'my_addons' ),
                ],
            ]
        );

        $this->add_control(
            'elements_per_line',
            [
                'label' => __( 'Nombre d\'éléments par ligne', 'my_addons' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 3,
                'min' => 2,
                'max' => 4,
                'step' => 1,
                'selectors' => [
                    '{{WRAPPER}} .docteur_lists .docteur_list' => 'width: calc(100% / {{VALUE}});',
                ],
            ]
        );

        $this->add_control(
            'space_enter',
            [
                'label' => esc_html__( 'Espace entre', 'my_addons' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .docteur_lists' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        //Image Style
        $this->start_controls_section(
            'style_image',
            [
                'label' => esc_html__( 'Image', 'my_addons' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]
        );

        $this->add_control(
            'image_border_radius',
            [
                'label' => __( 'Image Border Radius', 'my_addons' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .docteur_image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .docteur_image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        //Container contenu style
        $this->start_controls_section(
            'container_content_style',
            [
                'label' => esc_html__( 'Style du contenu', 'my_addons' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]
        );

        $this->add_control(
            'content_padding',
            [
                'label' => __( 'Contenu Padding', 'my_addons' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .docteur_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'content_border_radius',
            [
                'label' => __( 'Contenu Border Radius', 'my_addons' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .docteur_content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'style_card' => 'style1',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .docteur_content',
                'condition' => [
                    'style_card' => 'style1',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .docteur_content',
                'condition' => [
                    'style_card' => 'style1',
                ],
            ]
        );

        $this->add_control(
            'space_image_content',
            [
                'label' => esc_html__( 'Espace entre l\'image et le contenu', 'my_addons' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .default.docteur_list' => 'gap: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'style_card' => 'default',
                ],
            ]
        );

        $this->add_control(
            'space_title_content',
            [
                'label' => esc_html__( 'Espace entre les contenus', 'my_addons' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', 'em', 'rem', 'custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .docteur_content' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        //Bakcground overlay
        $this->start_controls_section(
            'container_overlay_background',
            [
                'label' => esc_html__( 'Supperposition d\'arrière plan', 'my_addons' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'style_card' => 'style1',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background_overlay',
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .background_overlay',
            ]
        );

        $this->end_controls_section();


        //Doctor name Style
        $this->start_controls_section(
            'style_name',
            [
                'label' => esc_html__( 'Police nom docteur', 'my_addons' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]

        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'doctor_name_typo',
                'selector' => '{{WRAPPER}} .docteur_name',
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label' => esc_html__( 'Text Color', 'my_addons' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .docteur_name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        //Doctor content Style
        $this->start_controls_section(
            'style_content',
            [
                'label' => esc_html__( 'Police spécialité docteur', 'my_addons' ),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,

            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'doctor_content_typo',
                'selector' => '{{WRAPPER}} .doctuer_speciality',
            ]
        );

        $this->add_control(
            'doctor_content_color',
            [
                'label' => esc_html__( 'Couleur', 'my_addons' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .doctuer_speciality' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();


    }


    /**
     * Render the widget output on the frontend.
     */
    protected function render() {
        $settings = $this->get_settings_for_display();

        // Récupérer les valeurs des contrôles
        $elements_per_line = isset($settings['elements_per_line']) ? $settings['elements_per_line'] : 3;



        $space_enter = isset($settings['space_enter']) ? $settings['space_enter'] : '10px';
        // Définir les styles en fonction des valeurs des contrôles
        $container_style = 'display: flex; flex-wrap: wrap; justify-content: center;gap:'.$space_enter["size"].$space_enter["unit"].'';
        $item_size = (100 / $elements_per_line) - 2 . '%';
        $item_style = 'width:'. $item_size . ';';
        // image border radius
        $image_border_radius = isset($settings['image_border_radius']) ? $settings['image_border_radius'] : '';

        ob_start();
        ?>
        <div class="docteur_lists" style="<?php echo $container_style; ?>">
            <?php if (!empty($settings['doctor'])) :
                foreach ($settings['doctor'] as $index => $item) :
                    $doctor_name = !empty($item['doctor_name']) ? $item['doctor_name'] : '';
                    $doctor_content = !empty($item['doctor_content']) ? $item['doctor_content'] : '';
                    $doctor_image = !empty($item['image']['url']) ? $item['image']['url'] : '';
                    ?>
                    <div class=" <?=$settings['style_card'];?> docteur_list " style="<?php echo $item_style; ?>">
                        <div class="docteur_image">
                            <div class="background_overlay"></div>
                            <img src="<?php echo $doctor_image; ?>" alt="<?php echo $doctor_name; ?>">
                        </div>
                        <div class="docteur_content" style="display: flex;flex-direction: column;">
                            <div class="docteur_name">
                                <?php echo $doctor_name; ?>
                            </div>
                            <div class="doctuer_speciality">
                                <?php echo $doctor_content; ?>
                            </div>
                        </div>
                    </div>
                <?php
                endforeach;
            endif;
            ?>
        </div>
        <?php
        echo ob_get_clean();
    }


    /**
     * Render the widget output in the editor.
     *
     * @param array $instance Widget instance.
     */
    protected function _content_template() {

    }


}

Plugin::instance()->widgets_manager->register_widget_type( new Card_Docteur_Widget() );
