;(function( $ ){
    "use strict";

    $(document).ready(function() {
        let currentVideo = $('#current-video')[0]; // Récupérer l'élément vidéo actuel

        $('.video-item').on('click', function() {
            let videoId = $(this).data('video-id');
            let videoContent = $(this).data('video-content');
            let videoUrl = 'https://www.youtube.com/embed/' + videoId + '?autoplay=1';

            // Mettre à jour la source de l'iframe avec la nouvelle vidéo
            $('#current-video').attr('src', videoUrl);

            // Mettre à jour le contenu de la vidéo en cours
            $('#current-video-content').html(videoContent);

            // Arrêter la lecture de la vidéo précédente
            currentVideo.contentWindow.postMessage('{"event":"command","func":"stopVideo","args":""}', '*');

            // Lancer la lecture automatique de la nouvelle vidéo
            currentVideo.contentWindow.postMessage('{"event":"command","func":"playVideo","args":""}', '*');
        });

        /** Cards docteur **/
        $(".style1").each(function () {
            const $_this = $(this);
            const docteur_content = $_this.find('.docteur_content');
            const paddingTopValue = parseFloat(docteur_content.css("padding-top"));
            const height = `${docteur_content.height() + (paddingTopValue * 2)}px`;

            const docteur_name = $_this.find('.docteur_name');
            const docteur_content_height = `${docteur_name.height() + (paddingTopValue * 2)}px`;

            docteur_content.css("max-height", docteur_content_height);

            $_this.hover(
                function() {
                    docteur_content.css("max-height", height);
                },
                function() {
                    docteur_content.css("max-height", docteur_content_height);
                }
            );
        });


        /**
         * Image carousel
         */

        let imageCarousel = function() {
            $('.carousel').slick({
                slidesToShow: 1,
                slidesToScroll: 1,
                centerMode: true,
                focusOnSelect: true,
                arrows: false,
                autoplay: true,
                autoplaySpeed: 3000,
                responsive: [
                    {
                        breakpoint: 768,
                        settings: {
                            centerMode: false,
                            focusOnSelect: false,
                        }
                    },
                ]
            });
        }

        $(window).on( 'elementor/frontend/init', function() {
            elementorFrontend.hooks.addAction( 'frontend/element_ready/gallery-widget.default', imageCarousel);
        });


        /**
         * Carousel
         */

        function initializeCarousel(carouselContainer) {
            const splide = new Splide('#' + carouselContainer, {
                perPage: 3,
                perMove: 3,
                padding: '5rem',
                focus: 'center',
                drag: 'free',
                speed: 2000,
                gap: 30,
                pagination: false,
                breakpoints: {
                    920: {
                        perPage: 2,
                        perMove: 1,
                    },
                    620: {
                        perPage: 1,
                        perMove: 1,
                        padding: '2rem',
                    },
                },
            });

            splide.mount();
        }

        const carousel = function () {
            $('.carousel_default .splide').each(function() {
                const carouselContainer = $(this).attr('id');
                initializeCarousel(carouselContainer);
            });
        }

        $(window).on('elementor/frontend/init', carousel);
        elementorFrontend.hooks.addAction('frontend/element_ready/myCarousel-widget.default', carousel);
        elementorFrontend.hooks.addAction('frontend/element_ready/editor', carousel); // Ajout de cette ligne

    });


})(jQuery);
