/**
 * USOF Field: Link
 */
! function( $, undefined ) {
	var _window = window,
		_document = document;

	if ( _window.$usof === undefined ) {
		return;
	}

	$usof.field[ 'link' ] = {

		init: function( options ) {
			this.parentInit( options );
			this.$mainField = this.$row.find( 'input[type="hidden"]:first' );
			this.$url = this.$row.find( 'input[type="text"]:first' );
			this.$target = this.$row.find( 'input[type="checkbox"]:first' );
			this.$row.on( 'click', '.usof-example', this.exampleClick.bind( this ) );
			this.format = this.$mainField.data( 'format' ) || 'JSON'; // Value format: serialized/JSON

			this.$url
				.on( 'change', this.applyChange.bind( this ) );
			this.$target
				.on( 'change', this.applyChange.bind( this ) );
		},

		// Link field has 2 different formats to store its value depending on where it is used
		applyChange: function(){
			// In case the field is used for a shortcode - use serialized format
			if ( this.format === 'serialized' ) {
				var value = this.getValue(),
					valueString = '';
				for ( var key in value ) {
					if ( value.hasOwnProperty( key ) && value[ key ] ) {
						valueString += key + ':' + usof_rawurlencode( value[ key ] ) + '|';
					}
				}

				if ( valueString.length > 0 ) {
					valueString = valueString.substring( 0, valueString.length - 1 );
				}

				this.$mainField.val( valueString );
				// In all other cases - use JSON format
			} else {
				this.$mainField.val( JSON.stringify( this.getValue() ) );
			}
			this.trigger( 'change', this.getValue() );
		},

		exampleClick: function( ev ) {
			var $target = $( ev.target ).closest( '.usof-example' ),
				example = $target.html();
			this.$url.val( example );
		},

		/**
		 * Determines whether the specified string is json.
		 *
		 * @param {string} value The string
		 * @return {boolean} True if the specified string is json, False otherwise.
		 */
		isJsonValue: function( value ) {
			try {
				JSON.parse( value );
			} catch ( e ) {
				return false;
			}
			return true;
		},

		getValue: function() {
			if ( ! this.inited ) {
				return {};
			}
			return {
				url: usof_rawurlencode( this.$url.val() ),
				target: this.$target.is( ':checked' ) ? '_blank' : ''
			};
		},

		setValue: function( value, quiet ) {
			if ( ! this.inited ) {
				return;
			}

			// Data type definitions when installing from JS
			if ( value && typeof value === 'string' || ! this.isJsonValue( value ) ) {
				this.format = 'serialized'
			}

			// Applying changes to the field according to its format
			if (
				this.format === 'serialized'
				&& (
					( '' + value ).substr( 0, 4 ) === 'url:'
					|| ( '' + value ).indexOf( '|' ) !== -1
				)
			) {
				this.$mainField.val( value );
				var pairs = value.trim().split( '|' );
				value = {};
				for ( var i = 0; i < pairs.length; i ++ ) {
					var param = pairs[ i ].split( ':' );
					if ( param[0] && param[1] ) {
						value[ param[0] ] = usof_rawurldecode( param[1] );
					}
				}
			} else {
				if ( typeof value != 'object' || value.url === undefined ) {
					value = {
						url: ( typeof value == 'string' ) ? value : ''
					}
				}
				this.$mainField.val( value );
			}

			if ( value.url ) {
				value.url = usof_rawurldecode( value.url );
			}

			this.$url.val( value.url );
			this.$target.attr( 'checked', ( value.target === '_blank' ) ? 'checked' : false );
		},

	};
}( jQuery );
