<?php defined( 'ABSPATH' ) OR die( 'This script cannot be accessed directly.' );

/**
 * Configuration for shortcode: cart
 */

$misc = us_config( 'elements_misc' );
$design_options_params = us_config( 'elements_design_options' );

/**
 * @return array
 */
return array(
	'title' => us_translate( 'Cart', 'woocommerce' ),
	'icon' => 'fas fa-shopping-cart',
	'place_if' => class_exists( 'woocommerce' ),
	'params' => us_set_params_weight(

		// General section
		array(
			'hide_empty' => array(
				'type' => 'switch',
				'switch_text' => us_translate( 'Hide if cart is empty', 'woocommerce' ),
				'std' => FALSE,
				'usb_preview' => array(
					'toggle_class' => 'hide_empty',
				),
			),
			'icon' => array(
				'title' => __( 'Icon', 'us' ),
				'type' => 'icon',
				'std' => 'fas|shopping-cart',
				'usb_preview' => TRUE,
			),
			'size' => array(
				'title' => __( 'Icon Size', 'us' ),
				'description' => $misc['desc_font_size'],
				'type' => 'text',
				'std' => '20px',
				'cols' => 3,
				'usb_preview' => TRUE,
			),
			'size_tablets' => array(
				'title' => __( 'Icon Size on Tablets', 'us' ),
				'description' => $misc['desc_font_size'],
				'type' => 'text',
				'std' => '20px',
				'cols' => 3,
				'usb_preview' => TRUE,
			),
			'size_mobiles' => array(
				'title' => __( 'Icon Size on Mobiles', 'us' ),
				'description' => $misc['desc_font_size'],
				'type' => 'text',
				'std' => '20px',
				'cols' => 3,
				'usb_preview' => TRUE,
			),
			'quantity_color_bg' => array(
				'title' => __( 'Quantity Badge Background', 'us' ),
				'type' => 'color',
				'clear_pos' => 'right',
				'std' => '_header_middle_text_hover',
				'cols' => 2,
				'usb_preview' => array(
					'css' => 'background',
				),
			),
			'quantity_color_text' => array(
				'title' => __( 'Quantity Badge Text', 'us' ),
				'type' => 'color',
				'clear_pos' => 'right',
				'with_gradient' => FALSE,
				'std' => '_header_middle_bg',
				'cols' => 2,
				'usb_preview' => array(
					'css' => 'color',
				),
			),
			'vstretch' => array(
				'title' => us_translate( 'Height' ),
				'type' => 'switch',
				'switch_text' => __( 'Stretch to the full available height', 'us' ),
				'std' => TRUE,
				'usb_preview' => array(
					'toggle_class' => 'height_full',
				),
			),
			'dropdown_effect' => array(
				'title' => __( 'Dropdown Effect', 'us' ),
				'type' => 'select',
				'options' => $misc['dropdown_effect_values'],
				'std' => 'height',
				'usb_preview' => array(
					'mod' => 'dropdown',
				),
			),
		),

		$design_options_params
	),
);
