/**
 * USOF Field: Switch
 */
! function( $, undefined ) {
	var _window = window,
		_document = document;

	if ( _window.$usof === undefined ) {
		return;
	}

	$usof.field[ 'switch' ] = {
		init: function() {
			// Event handlers
			this._events = {
				changeValue: this._changeValue.bind( this )
			};
			// Events
			this.$input
				.on( 'change', this._events.changeValue );
		},
		_changeValue: function( e ) {
			var newValue = this.$input.is( ':checked' ) ? 1 : 0;
			this.setValue( newValue );
		},
		/**
		 * Get the value
		 *
		 * @return {mixed} The value
		 */
		getValue: function() {
			return this.$input.is( ':checked' ) ? 1 : '';
		},
		/**
		 * Set the value.
		 *
		 * @param {mixed} value The value
		 * @param {boolean} quiet The quiet
		 */
		setValue: function( value, quiet ) {
			if ( typeof value !== 'boolean' ) {
				value = parseInt( value );
			}
			this.$input
				.prop( 'checked', !! value )
				.val( value );
			if ( ! quiet ) {
				this.trigger( 'change', [value] );
			}
		}
	};
}( jQuery );
