<?php
namespace Elementor;

use Elementor\Widget_Base;

class Custom_Video_Widget extends Widget_Base {

    public function get_name() {
        return 'custom-video-widget';
    }

    public function get_title() {
        return __( 'Custom Video Widget', 'hulsia_addons' );
    }

    public function get_icon() {
        return 'eicon-video-camera';
    }

    public function get_categories() {
        return [ 'myew-for-elementor' ];
    }



    protected function _register_controls() {
        $this->start_controls_section(
            'section_content',
            [
                'label' => __( 'Content', 'hulsia_addons' ),
            ]
        );

        $this->add_control(
            'default_title',
            [
                'label' => __( 'Default title', 'hulsia_addons' ),
                'type' =>  \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Video Title', 'hulsia_addons' ),
            ]
        );

        $this->add_control(
            'default_description',
            [
                'label' => esc_html__( 'Default description', 'hulsia_addons' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__( 'Default description', 'hulsia_addons' ),
                'placeholder' => esc_html__( 'Type your description here', 'hulsia_addons' ),
                'label_block' => true
            ]
        );


        // List video
        $list_video = new \Elementor\Repeater();

        // Categories
        $list_video->add_control(
            'list_title',
            [
                'label' => esc_html__( 'Title of video section', 'hulsia_addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Video Section 1', 'hulsia_addons'),
                'label_block' => true
            ]
        );

        // Video

        $video = new \Elementor\Repeater();

        //Video title
        $video->add_control(
            'video_title',
            [
                'label' => esc_html__( 'Title of video', 'hulsia_addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Title Video 1', 'hulsia_addons'),
                'label_block' => true
            ]
        );

        // Video description
        $video->add_control(
            'video_description',
            [
                'label' => esc_html__( 'Description of video', 'hulsia_addons' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => esc_html__( 'Default description', 'hulsia_addons' ),
                'placeholder' => esc_html__( 'Type your description here', 'hulsia_addons' ),
                'label_block' => true
            ]
        );


        $video->add_control(
            'video',
            [
                'label' => esc_html__( 'Vidéo', 'hulsia_addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        //Video Poster
        $video->add_control(
            'poster',
            [
                'label' => esc_html__( 'Image thumbails', 'hulsia_addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $list_video->add_control(
            'video_items',
            [
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $video->get_controls(),
            ]
        );

        $this->add_control(
            'list_video',
            [
                'label' => esc_html__( 'List videos', 'hulsia_addons' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $list_video->get_controls(),
                'default' => [
                    [
                        'list_title' => esc_html__( 'Video Item #1', 'hulsia_addons' ),
                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'section_pagination',
            [
                'label' => __( 'Button Pagination', 'hulsia_addons' ),
            ]
        );
        $this->add_control(
            'load_more_button_text',
            [
                'label' => esc_html__( 'Text button load more', 'hulsia_addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Load more video', 'hulsia_addons'),
                'label_block' => true
            ]
        );
        $this->add_control(
            'videos_per_category',
            array(
                'label' => __( 'Videos Per Category', 'hulsia_addons' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 5, // Définissez une valeur par défaut ici
                'min' => 1, // Définissez la valeur minimale si nécessaire
                'description' => __( 'Enter the number of videos to display per category.', 'your-text-domain' ),
            )
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();
        $widget_id = $this->get_id();
        ?>
        <div class="video-widget">
            <div class="video-section">
                <div class="video-player">
                    <video id="video-player" class="full-video" width="560" height="315" poster="<?php echo esc_attr( $settings['default_poster'] ); ?>" src=""></video>
                </div>
                <div class="video-content">
                    <h3 class="default-title"><?php echo esc_html( $settings['default_title'] ); ?></h3>
                    <div class="default-description">
                        <?php echo  $settings['default_description'] ; ?>
                    </div>
                </div>
            </div>

            <div class="video-list">
                <?php foreach ( $settings['list_video'] as $index => $video ) : ?>
                    <div class="videos">
                        <div class="videos-header">
                            <h3><?php echo esc_html( $video['list_title'] ); ?></h3>
                            <?php if ( count( $video['video_items'] ) > 5 ) : ?>
                                <form class="load-more-form" action="<?=admin_url('admub-ajax.php');?>" method="post">
                                    <input type="hidden" name="action" value="custom_video_widget_load_more">
                                    <input type="hidden" name="widget_id" value="<?php echo esc_attr( $this->get_id() ); ?>">
                                    <input type="hidden" name="category" value="<?php echo esc_attr( $index ); ?>">
                                    <input type="hidden" name="offset" value="0">
                                    <input
                                            type="hidden"
                                            name="nonce"
                                            value="<?php echo wp_create_nonce( 'custom_video_widget_load_more' ); ?>"
                                    >
                                    <input name="load_more" type="submit" class="load-more-videos" value="<?php echo esc_attr( $settings['load_more_button_text'] ); ?>">
                                </form>
                            <?php endif; ?>
                        </div>

                        <div class="video-row" id="video-row-<?php echo esc_attr( $this->get_id() ); ?>-<?php echo esc_attr( $index ); ?>">
                            <?php if ( ! empty( $video['video_items'] ) ) : ?>
                                <?php $count = 0; ?>
                                <?php foreach ( $video['video_items'] as $video_item ) : ?>
                                    <?php if ( $count >= 5 ) break; ?>
                                    <div class="video" data-src="<?php echo esc_attr( $video_item['video']['url'] ); ?>">
                                        <img src="<?php echo esc_attr( $video_item['poster']['url'] ); ?>" alt="">
                                        <p class="video-title"><?php echo esc_html( $video_item['video_title'] ); ?></p>
                                        <div class="video-text"><?php echo $video_item['video_description']; ?></div>
                                    </div>
                                    <?php $count++; ?>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>

                        <?php if ( count( $video['video_items'] ) > 5 ) : ?>
                            <form class="load-more-form" style="display: none;">
                                <input type="hidden" name="action" value="custom_video_widget_load_more">
                                <input type="hidden" name="widget_id" value="<?php echo esc_attr( $this->get_id() ); ?>">
                                <input type="hidden" name="category" value="<?php echo esc_attr( $index ); ?>">
                                <input type="hidden" name="offset" value="5">
                                <?php wp_nonce_field( 'custom_video_widget_nonce', 'custom_video_widget_nonce' ); ?>
                                <input type="submit" class="load-more-videos" value="<?php echo esc_attr( $settings['load_more_button_text'] ); ?>">
                            </form>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <script>
            // Attacher un gestionnaire d'événement à la soumission du formulaire
            var loadMoreForms = document.getElementsByClassName('load-more-form');
            for (var i = 0; i < loadMoreForms.length; i++) {
                loadMoreForms[i].addEventListener('submit', function(event) {
                    event.preventDefault(); // Empêcher le rechargement de la page

                    // Récupérer les données du formulaire
                    var form = event.target;
                    var formData = new FormData(form);

                    // Effectuer une requête AJAX pour charger les vidéos supplémentaires
                    var xhr = new XMLHttpRequest();
                    xhr.open('POST', '<?php echo admin_url('admin-ajax.php'); ?>', true);
                    xhr.onreadystatechange = function() {
                        if (xhr.readyState === 4 && xhr.status === 200) {
                            console.log(xhr.responseText)

                        }
                    };
                    xhr.send(formData);
                });
            }

            document.addEventListener('DOMContentLoaded', function() {



                var firstVideoSource = document.querySelector('.videos .video:first-child').getAttribute('data-src');
                var firstVideoPoster = document.querySelector('.videos .video:first-child img').getAttribute('src');
                var firstVideoTitle = document.querySelector('.videos .video:first-child .video-title').textContent;
                var firstVideoText = document.querySelector('.videos .video:first-child .video-text').textContent;

                // Définir la source de la vidéo de la section lecture avec la source de la première vidéo
                document.getElementById('video-player').src = firstVideoSource;
                document.getElementById('video-player').poster = firstVideoPoster;
                document.querySelector('.default-title').textContent = firstVideoTitle;
                document.querySelector('.default-description').textContent = firstVideoText;

                var videos = document.querySelectorAll('.video');
                var videoPlayer = document.getElementById('video-player');

                videos.forEach(function(video) {
                    video.addEventListener('click', function() {

                        var videoPath = this.getAttribute('data-src');
                        var videoPoster = this.querySelector('img').getAttribute('src');
                        var videoTitle = this.querySelector('.video-title').textContent;
                        var videoText = this.querySelector('.video-text').textContent;

                        videoPlayer.src = videoPath;
                        videoPlayer.poster = videoPoster;
                        videoPlayer.play();
                        document.querySelector('.default-title').textContent = videoTitle;
                        document.querySelector('.default-description').textContent = videoText;
                    });
                });
            });
        </script>

        <?php

    }


}


Plugin::instance()->widgets_manager->register_widget_type( new Custom_Video_Widget() );


