<?php

namespace WP_Rplg_Google_Reviews\Includes;

use WP_Rplg_Google_Reviews\Includes\Core\Core;

class Builder_Page {

    public function __construct(Feed_Deserializer $feed_deserializer, Core $core, View $view) {
        $this->feed_deserializer = $feed_deserializer;
        $this->core = $core;
        $this->view = $view;
    }

    public function register() {
        add_action('grw_admin_page_grw-builder', array($this, 'init'));
    }

    public function init() {
        if (isset($_GET['grw_notice'])) {
            $this->add_admin_notice();
        }

        $feed = null;
        if (isset($_GET[Post_Types::FEED_POST_TYPE . '_id'])) {
            $feed = $this->feed_deserializer->get_feed(sanitize_text_field(wp_unslash($_GET[Post_Types::FEED_POST_TYPE . '_id'])));
        }

        $this->render($feed);
    }

    public function add_admin_notice($notice_code = 0) {

    }

    public function render($feed) {
        global $wp_version;
        if (version_compare($wp_version, '3.5', '>=')) {
            wp_enqueue_media();
        }

        wp_nonce_field('grw_wpnonce', 'grw_nonce');

        $feed_id = '';
        $feed_post_title = '';
        $feed_content = '';
        $feed_inited = false;
        $businesses = null;
        $reviews = null;

        if ($feed != null) {
            $feed_id = $feed->ID;
            $feed_post_title = $feed->post_title;
            $feed_content = trim($feed->post_content);

            $data = $this->core->get_reviews($feed, true);
            $businesses = $data['businesses'];
            $reviews = $data['reviews'];
            $options = $data['options'];
            if (isset($businesses) && count($businesses) || isset($reviews) && count($reviews)) {
                $feed_inited = true;
            }
        }

        ?>
        <div class="grw-builder">
            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php?action=' . Post_Types::FEED_POST_TYPE . '_save')); ?>">
                <input type="hidden" name="<?php echo Post_Types::FEED_POST_TYPE; ?>[post_id]" value="<?php echo esc_attr($feed_id); ?>">
                <input type="hidden" name="<?php echo Post_Types::FEED_POST_TYPE; ?>[current_url]" value="<?php echo home_url($_SERVER['REQUEST_URI']); ?>">
                <div class="grw-builder-workspace">
                    <div class="grw-toolbar">
                        <div class="grw-toolbar-title">
                            <input id="grw_title" class="grw-toolbar-title-input" type="text" name="<?php echo Post_Types::FEED_POST_TYPE; ?>[title]" value="<?php if (isset($feed_post_title)) { echo $feed_post_title; } ?>" placeholder="Enter a widget name" maxlength="255" autofocus>
                        </div>
                        <div class="grw-toolbar-control">
                            <?php if ($feed_inited) { ?>
                            <label>
                                <span id="grw_sc_msg">Shortcode </span>
                                <input id="grw_sc" type="text" value="[grw id=&quot;<?php echo esc_attr($feed_id); ?>&quot;]" data-grw-shortcode="[grw id=&quot;<?php echo esc_attr($feed_id); ?>&quot;]" onclick="this.select(); document.execCommand('copy'); window.grw_sc_msg.innerHTML = 'Shortcode Copied! ';" readonly/>
                            </label>
                            <div class="grw-toolbar-options">
                                <label title="Sometimes, you need to use this shortcode in PHP, for instance in header.php or footer.php files, in this case use this option"><input type="checkbox" onclick="var el = window.grw_sc; if (this.checked) { el.value = '&lt;?php echo do_shortcode( \'' + el.getAttribute('data-grw-shortcode') + '\' ); ?&gt;'; } else { el.value = el.getAttribute('data-grw-shortcode'); } el.select();document.execCommand('copy'); window.grw_sc_msg.innerHTML = 'Shortcode Copied! ';"/>Use in PHP</label>
                            </div>
                            <?php } ?>
                            <button id="grw_save" type="submit" class="button button-primary">Save & Update</button>
                        </div>
                    </div>
                    <div class="grw-builder-preview">
                        <textarea id="grw-builder-connection" name="<?php echo Post_Types::FEED_POST_TYPE; ?>[content]" style="display:none"><?php echo $feed_content; ?></textarea>
                        <?php
                        if ($feed_inited) {
                            echo $this->view->render($feed_id, $businesses, $reviews, $options, true);
                        } else {
                            ?>To show reviews in this preview, firstly connect it on the right menu (CONNECT GOOGLE) and click
                            '<b>Save & Update</b>' button. Then you can use this created widget on a sidebar or through a shortcode.<?php
                        }
                        ?>
                    </div>
                </div>
                <div id="grw-builder-option" class="grw-builder-options"></div>
            </form>
        </div>
        <script>
            jQuery(document).ready(function($) {
                function grw_builder_init_listener(attempts) {
                    if (!window.grw_builder_init) {
                        if (attempts > 0) {
                            setTimeout(function() { grw_builder_init_listener(attempts - 1); }, 200);
                        }
                        return;
                    }
                    grw_builder_init($, {
                        el: '#grw-builder-option',
                        use_gpa: true,
                        <?php if (strlen($feed_content) > 0) { ?>
                        conns: <?php echo $feed_content; ?>
                        <?php } ?>
                    });
                }
                grw_builder_init_listener(20);
            });
        </script>
        <style>
            .update-nag { display: none; }
        </style>
        <?php
    }
}
