<?php

namespace WP_Rplg_Google_Reviews\Includes;

class Assets {

    private $url;
    private $version;
    private $suffix;

    private static $css_assets = array(
        'feedbuilder'      => 'css/feedbuilder',
        'grw-admin-css'    => 'css/admin',
        'grw-rplg-css'     => 'css/rplg-wp',
        'grw-setting-css'  => 'css/rplg-setting',
        'grw-css'          => 'css/google-review',
    );

    private static $js_assets = array(
        'grw-admin-js'     => 'js/admin',
        'feedbuilder'      => 'js/feedbuilder',
        'grw-time-js'      => 'js/wpac-time',
        'grw-wpac-js'      => 'js/wpac',
        'blazy-js'         => 'js/blazy.min',
        'grw-js'           => 'js/rplg',
    );

    public function __construct($url, $version) {
        $this->url     = $url;
        $this->version = $version;
        $this->suffix  = '';
    }

    public function register() {
        if (is_admin()) {
            add_action('admin_enqueue_scripts', array($this, 'register_styles'));
            add_action('admin_enqueue_scripts', array($this, 'register_scripts'));
            add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_styles'));
            add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_scripts'));
        } else {
            add_action('wp_enqueue_scripts', array($this, 'register_styles'));
            add_action('wp_enqueue_scripts', array($this, 'register_scripts'));
            $grw_demand_assets = get_option('grw_demand_assets');
            if (!$grw_demand_assets || $grw_demand_assets != 'true') {
                add_action('wp_enqueue_scripts', array($this, 'enqueue_public_styles'));
                add_action('wp_enqueue_scripts', array($this, 'enqueue_public_scripts'));
            }
        }
    }

    public function register_styles() {
        $this->register_styles_loop(array('feedbuilder', 'grw-admin-css', 'grw-rplg-css', 'grw-setting-css', 'grw-css'));
    }

    public function register_scripts() {
        $this->register_scripts_loop(array('grw-admin-js', 'feedbuilder', 'grw-time-js', 'grw-wpac-js', 'blazy-js', 'grw-js'));
    }

    public function enqueue_admin_styles() {
        wp_enqueue_style('feedbuilder');
        wp_enqueue_style('grw-admin-css');
        wp_enqueue_style('grw-rplg-css');
        wp_enqueue_style('grw-setting-css');
        wp_enqueue_style('grw-css');
    }

    public function enqueue_admin_scripts() {
        wp_enqueue_script('jquery');
        wp_enqueue_script('jquery-ui-core');
        wp_enqueue_script('jquery-ui-draggable');
        wp_enqueue_script('jquery-ui-sortable');

        wp_enqueue_script('grw-wpac-js');
        wp_enqueue_script('grw-admin-js');

        wp_localize_script('feedbuilder', 'GRW_VARS', array(
            'googleAPIKey'  => get_option('grw_google_api_key'),
            'GOOGLE_AVATAR' => GRW_GOOGLE_AVATAR,
            'handlerUrl'    => admin_url('options-general.php?page=grw'),
            'supportUrl'    => admin_url('admin.php?page=grw-support'),
            'actionPrefix'  => 'grw',
            'wordpress'     => true,
        ));
        wp_enqueue_script('feedbuilder');

        wp_enqueue_script('grw-time-js');
        wp_enqueue_script('blazy-js');
        wp_enqueue_script('grw-js');
    }

    public function enqueue_public_styles() {
        wp_enqueue_style('grw-css');
    }

    public function enqueue_public_scripts() {
        wp_enqueue_script('grw-time-js');
        //wp_enqueue_script('blazy-js');
        wp_enqueue_script('grw-js');
    }

    public function get_public_styles() {
        return array($this->get_css_asset('grw-css'));
    }

    public function get_public_scripts() {
        return array(
            $this->get_js_asset('grw-time-js'),
            $this->get_js_asset('blazy-js'),
            $this->get_js_asset('grw-js'),
        );
    }

    private function register_styles_loop($styles) {
        foreach ($styles as $style) {
            wp_register_style($style, $this->get_css_asset($style), array(), $this->version);
        }
    }

    private function register_scripts_loop($scripts) {
        foreach ($scripts as $script) {
            wp_register_script($script, $this->get_js_asset($script), array(), $this->version);
        }
    }

    private function get_css_asset($asset) {
        return $this->url . self::$css_assets[$asset] . $this->suffix . '.css';
    }

    private function get_js_asset($asset) {
        return $this->url . self::$js_assets[$asset] . $this->suffix . '.js';
    }

}