<?php
/**
 * Plugin Name: Hulsia Elementor addons
 * Description: Custom Elementor Addons
 * Plugin URI:  https://example.com/
 * Version:     1.0.0
 * Author:      Aina ANDRIANIRINA
 * Author URI:  https://example.com/
 * Text Domain: my_addons
 *
 * Elementor tested up to: 3.7.0
 * Elementor Pro tested up to: 3.7.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}


final class hulisa_elementor_addons {
    // Plugin version

    const VERSION = '1.0.0';

    // Minimum Elementor Version

    const MINIMUM_ELEMENTOR_VERSION = '3.7.0';

    // Minimum PHP Version
    const MINIMUM_PHP_VERSION = '7.0';

    /**
     * Instance
     *
     * @since 1.0.0
     * @access private
     * @static
     * @var \hulisa_elementor_addons\Plugin The single instance of the class.
     */

    private static $_instance = null;

    /**
     * Instance
     *
     * Ensures only one instance of the class is loaded or can be loaded.
     *
     * @since 1.0.0
     * @access public
     * @static
     * @return \hulisa_elementor_addons\Plugin An instance of the class.
     */

    public static function instance() {
        if(is_null(self::$_instance)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }


    /**
     * Constructor
     *
     * Perform some compatibility checks to make sure basic requirements are meet.
     * If all compatibility checks pass, initialize the functionality.
     *
     * @since 1.0.0
     * @access public
     */
    public function __construct()
    {
        // Call Constants Method

        $this->define_constants();

        add_action( 'wp_enqueue_scripts', [ $this, 'scripts_styles' ] );


        add_action( 'init', [$this, 'i18n'] );

        if ( $this->is_compatible() ) {
            add_action( 'elementor/init', [ $this, 'init' ] );
        }


    }


    /**
     * Compatibility Checks
     *
     * Checks whether the site meets the addon requirement.
     *
     * @since 1.0.0
     * @access public
     */
    public function is_compatible() {

        // Check if Elementor is installed and activated
        if ( ! did_action( 'elementor/loaded' ) ) {
            add_action( 'admin_notices', [ $this, 'admin_notice_missing_main_plugin' ] );
            return false;
        }

        // Check for required Elementor version
        if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
            add_action( 'admin_notices', [ $this, 'admin_notice_minimum_elementor_version' ] );
            return false;
        }

        // Check for required PHP version
        if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
            add_action( 'admin_notices', [ $this, 'admin_notice_minimum_php_version' ] );
            return false;
        }

        return true;

    }


    /**
     * Initialize
     *
     * Load the addons functionality only after Elementor is initialized.
     *
     * Fired by `elementor/init` action hook.
     *
     * @since 1.0.0
     * @access public
     */

    public function init() {
        add_action('elementor/elements/categories_registered', [$this, 'init_category']);
        add_action( 'elementor/widgets/register', [ $this, 'init_widgets' ]);;
    }

    /**
     * Define constants
     * @return void
     */
    public function define_constants() {
        define('MY_ADDONS_PLUGIN_URL', trailingslashit(plugins_url('/', __FILE__)));
        define('MY_ADDONS_PLUGIN_PATH', trailingslashit(plugin_dir_path( __FILE__)));
    }


    /**
     * Load Scripts & Styles
     * @return void
     */
    public function scripts_styles() {

        wp_register_style( 'owl-carousel-style', MY_ADDONS_PLUGIN_URL . 'assets/vendor/owl-carousel/css/owl.carousel.min.css', [], rand(), 'all' );
        wp_register_style( 'owl-carousel-theme-style', MY_ADDONS_PLUGIN_URL . 'assets/vendor/owl-carousel/css/owl.theme.default.min.css', [], rand(), 'all' );
        wp_register_script( 'owl-carousel-script', MY_ADDONS_PLUGIN_URL . 'assets/vendor/owl-carousel/js/owl.carousel.min.js', [ 'jquery' ], rand(), true );

        wp_register_style('my-addons-style', MY_ADDONS_PLUGIN_URL .'assets/dist/css/public.min.css', [], rand(), 'all');
        wp_register_script('my-addons-script',MY_ADDONS_PLUGIN_URL .'assets/dist/js/public.min.js', ['jquery'], rand(), true );
        wp_register_script( 'circuit-list-widget',MY_ADDONS_PLUGIN_URL .'assets/dist/js/circuit-list-widget.min.js', ['jquery'], rand(),  true );

        wp_enqueue_style('owl-carousel-style');
        wp_enqueue_style('owl-carousel-theme-style');
        wp_enqueue_script('owl-carousel-script');

        wp_enqueue_style('my-addons-style');
        wp_enqueue_script('my-addons-script');
        wp_enqueue_script('circuit-list-widget');

    }


    /**
     * Load Text Domain
     * @return void
     */
    public function i18n() {
        load_plugin_textdomain('my_addons', false, dirname(plugin_basename(  __FILE__)).'/languages');
    }



    /**
     * Init Widgets
     */

    public function init_widgets() {
        require_once MY_ADDONS_PLUGIN_PATH . '/widgets/video_list.php';
        require_once MY_ADDONS_PLUGIN_PATH . '/widgets/card_docteur.php';
    }


    /**
     * Init Category Section
     */

    public function init_category($elements_manager) {
        $elements_manager->add_category(
            'myew-for-elementor',
            [
                'title' => esc_html__( 'Hulsia Elementor Addons', 'my_addons' ),
                'icon' => 'fa fa-plug',
            ]
        );
    }


    /**
     * Admin notice
     *Warning when the site doesn't have Elementor installed or activated.
     *
     * @since 1.0.0
     * @access public
     */
    public function admin_notice_missing_main_plugin() {

        if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

        $message = sprintf(
        /* translators: 1: Plugin name 2: Elementor */
            esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'elementor-test-addon' ),
            '<strong>' . esc_html__( 'Hulsia Elementor Addons', 'my_addons' ) . '</strong>',
            '<strong>' . esc_html__( 'Elementor', 'my_addons' ) . '</strong>'
        );

        printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

    }


    /**
     * Admin notice
     *
     * Warning when the site doesn't have a minimum required Elementor version.
     *
     * @since 1.0.0
     * @access public
     */
    public function admin_notice_minimum_elementor_version() {

        if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

        $message = sprintf(
        /* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
            esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'my_addons' ),
            '<strong>' . esc_html__( 'Hulsia Elementor Addons', 'my_addons' ) . '</strong>',
            '<strong>' . esc_html__( 'Elementor', 'my_addons' ) . '</strong>',
            self::MINIMUM_ELEMENTOR_VERSION
        );

        printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

    }

    /**
     * Admin notice
     *
     * Warning when the site doesn't have a minimum required PHP version.
     *
     * @since 1.0.0
     * @access public
     */
    public function admin_notice_minimum_php_version() {

        if ( isset( $_GET['activate'] ) ) unset( $_GET['activate'] );

        $message = sprintf(
        /* translators: 1: Plugin name 2: PHP 3: Required PHP version */
            esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'my_addons' ),
            '<strong>' . esc_html__( 'Hulsia Elementor Addons', 'my_addons' ) . '</strong>',
            '<strong>' . esc_html__( 'PHP', 'my_addons' ) . '</strong>',
            self::MINIMUM_PHP_VERSION
        );

        printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );

    }


}

hulisa_elementor_addons::instance();
