;(function( $ ){
    "use strict";

    $(document).ready(function() {
        let currentVideo = $('#current-video')[0]; // Récupérer l'élément vidéo actuel

        $('.video-item').on('click', function() {
            let videoId = $(this).data('video-id');
            let videoContent = $(this).data('video-content');
            let videoUrl = 'https://www.youtube.com/embed/' + videoId + '?autoplay=1';

            // Mettre à jour la source de l'iframe avec la nouvelle vidéo
            $('#current-video').attr('src', videoUrl);

            // Mettre à jour le contenu de la vidéo en cours
            $('#current-video-content').html(videoContent);

            // Arrêter la lecture de la vidéo précédente
            currentVideo.contentWindow.postMessage('{"event":"command","func":"stopVideo","args":""}', '*');

            // Lancer la lecture automatique de la nouvelle vidéo
            currentVideo.contentWindow.postMessage('{"event":"command","func":"playVideo","args":""}', '*');
        });


        $(".docteur_list").each(function () {
            const $_this = $(this);
            const docteur_content = $_this.find('.docteur_content');
            const paddingTopValue = parseFloat(docteur_content.css("padding-top"));
            const height = `${docteur_content.height() + (paddingTopValue * 2)}px`;

            const docteur_name = $_this.find('.docteur_name');
            const docteur_content_height = `${docteur_name.height() + (paddingTopValue * 2)}px`;

            docteur_content.css("max-height", docteur_content_height);

            $_this.hover(
                function() {
                    docteur_content.css("max-height", height);
                },
                function() {
                    docteur_content.css("max-height", docteur_content_height);
                }
            );
        });




    });
})(jQuery);
