<?php
namespace Elementor;

use Elementor\Widget_Base;

class Video_List_Widget extends Widget_Base {

    /**
     * Retrieve the widget name.
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'my_video_list';
    }

    /**
     * Retrieve the widget title.
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __( 'Liste de vidéo', 'my_addons' );
    }

    /**
     * Retrieve the widget icon.
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-video-playlist';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return ['myew-for-elementor'];
    }

    /**
     * Retrieve the widget control options.
     *
     * @return array Widget control options.
     */
    protected function _register_controls() {
        $this->start_controls_section(
            'section_video_playlist',
            [
                'label' => __( 'Video Playlist', 'my_addons' ),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'video_title',
            [
                'label' => __( 'Video Title', 'my_addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Video Title', 'my_addons' ),
            ]
        );

        $repeater->add_control(
            'video_url',
            [
                'label' => __( 'Video URL', 'my_addons' ),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '',
                ],
            ]
        );

        $repeater->add_control(
            'video_content',
            [
                'label' => __( 'Video Content', 'my_addons' ),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => '',
            ]
        );

        $this->add_control(
            'videos',
            [
                'label' => __( 'Videos', 'my_addons' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [],
                'title_field' => '{{{ video_title }}}',
            ]
        );

        $this->end_controls_section();
    }


    /**
     * Render the widget output on the frontend.
     */
    protected function render() {
        $settings = $this->get_settings();

        if ( ! empty( $settings['videos'] ) ) {
            ?>
            <div class="video-playlist">
                <div class="video-current">
                    <?php
                    // Afficher la vidéo en cours
                    $current_video = $settings['videos'][0];
                    if ( ! empty( $current_video['video_url']['url'] ) ) {
                        $video_id = $this->get_youtube_video_id( $current_video['video_url']['url'] );
                        $video_embed_url = 'https://www.youtube.com/embed/' . $video_id;
                        ?>
                        <div class="current-video">
                            <iframe id="current-video" src="<?php echo esc_url( $video_embed_url ); ?>" frameborder="0" autoplay allowfullscreen></iframe>
                        </div>
                        <div class="current-video-content" id="current-video-content">
                            <?php echo $current_video['video_content']; ?>
                        </div>
                        <?php
                    }
                    ?>
                </div>
                <div class="video-list">
                    <?php
                    // Afficher la liste des vidéos
                    foreach ( $settings['videos'] as $index => $video ) {
                        if ( empty( $video['video_url']['url'] ) ) {
                            continue;
                        }
                        $video_id = $this->get_youtube_video_id( $video['video_url']['url'] );
                        $video_thumbnail_url = 'https://img.youtube.com/vi/' . $video_id . '/0.jpg';
                        ?>
                        <div class="video-item" data-video-id="<?php echo esc_attr( $video_id ); ?>" data-video-content="<?php echo esc_attr( $video['video_content'] ); ?>">
                            <div class="video-thumbnail">
                                <img src="<?php echo esc_url( $video_thumbnail_url ); ?>" alt="<?php echo esc_attr( $video['video_title'] ); ?>" />
                                <div class="play">
                                    <svg width="27" height="20" viewBox="0 0 27 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M0.694902 3.75104C1.00204 2.59729 1.6754 1.62073 2.82915 1.31359C4.92008 0.75443 13.5004 0.703239 13.5004 0.703239C13.5004 0.703239 22.0807 0.75443 24.1716 1.31359C25.3254 1.62073 25.9948 2.59729 26.3059 3.75104C26.865 5.84198 26.8887 10.1538 26.8887 10.1538C26.8887 10.1538 26.865 14.4656 26.3059 16.5565C25.9987 17.7103 25.3254 18.6868 24.1716 18.994C22.0807 19.5531 13.5004 19.6043 13.5004 19.6043C13.5004 19.6043 4.92008 19.5531 2.82915 18.994C1.6754 18.6868 1.00204 17.7103 0.694902 16.5565C0.135744 14.4656 0.112116 10.1538 0.112116 10.1538C0.112116 10.1538 0.135744 5.84198 0.694902 3.75104Z" fill="#FF0000"/>
                                        <path d="M9.16795 10.1538L16.2559 6.21606V14.0915" fill="white"/>
                                    </svg>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                    ?>
                </div>
            </div>
            <?php
        }
    }
    /**
     * Render the widget output in the editor.
     *
     * @param array $instance Widget instance.
     */
    protected function _content_template() {

    }



    private function get_youtube_video_id( $url ) {
        $video_id = '';

        // Extraire l'ID de la vidéo de l'URL
        $parsed_url = parse_url( $url );
        if ( isset( $parsed_url['query'] ) ) {
            parse_str( $parsed_url['query'], $query_params );
            if ( isset( $query_params['v'] ) ) {
                $video_id = $query_params['v'];
            }
        } elseif ( isset( $parsed_url['path'] ) ) {
            $path_parts = explode( '/', trim( $parsed_url['path'], '/' ) );
            if ( in_array( 'embed', $path_parts ) && isset( $path_parts[ count( $path_parts ) - 1 ] ) ) {
                $video_id = $path_parts[ count( $path_parts ) - 1 ];
            }
        }

        return $video_id;
    }

}

Plugin::instance()->widgets_manager->register_widget_type( new Video_List_Widget() );
