/******* Do not edit this file *******
Simple Custom CSS and JS - by Silkypress.com
Saved: Jun 23 2023 | 14:47:27 */
class Tooltip {
  static activeTooltip = null;

  static bind(selector) {
    document.querySelectorAll(selector).forEach(element => new Tooltip(element));
  }

  constructor(element) {
    this.element = element;
    let tooltipTarget = this.element.getAttribute('data-tooltip');

    if (tooltipTarget) {
      this.title = document.querySelector(tooltipTarget).innerHTML;
    } else {
      this.title = element.getAttribute('title');
    }
    this.tooltip = null;
    this.element.addEventListener('click', this.open.bind(this));
  }

  open(e) {
    e.preventDefault();
    if (Tooltip.activeTooltip !== null && Tooltip.activeTooltip !== this) {
      Tooltip.activeTooltip.close();
    }

    if (this.tooltip === null) {
      let tooltip = this.createTooltip();
      let width = this.tooltip.offsetWidth;
      let height = this.tooltip.offsetHeight;
      let left =
        this.element.style.width / 80 -
        width / 80 +
        20 +
        this.element.getBoundingClientRect().left +
        document.documentElement.scrollLeft;
      let top =
        this.element.getBoundingClientRect().top -
        height -
        15 +
        document.documentElement.scrollTop +
        14;
      tooltip.style.left = left + 'px';
      tooltip.style.top = top + 'px';
      tooltip.classList.add('visible');
      let close = this.tooltip.querySelector('.close_tooltip');
      close.addEventListener('click', e => {
        e.preventDefault();
        this.close();
      });
      Tooltip.activeTooltip = this;
    } else {
      this.close();
    }
  }

  close() {
    if (this.tooltip !== null) {
      this.tooltip.classList.remove('visible');
      document.body.removeChild(this.tooltip);
      this.tooltip = null;
      Tooltip.activeTooltip = null;
    }
  }

  createTooltip() {
    if (this.tooltip == null) {
      let tooltip = document.createElement('div');
      tooltip.innerHTML = this.title;
      tooltip.classList.add('tippy');
      document.body.appendChild(tooltip);
      this.tooltip = tooltip;
    }
    return this.tooltip;
  }
}

Tooltip.bind('.open_tooltip');

document.querySelectorAll('.container_map a').forEach(function (element) {
  element.addEventListener('click', e => {
    e.preventDefault();
  });
});
