<?php
/**
 * Plugin Name: ophtalea fonctionality
 * Description: A Shortcode of site fonctionality.
 * Author: Hulsia
 * Version: 1.0.0
 */


if ( ! defined( 'ABSPATH' ) ) {
    exit;
}


/**
 * Add a custom assets for a popup
 * @return void
 */

function hulsia_ophtalea_assets() {

    wp_enqueue_style('splide', plugins_url('assets/css/splide.min.css', __FILE__) , array(),'4.1.3', 'all');


    wp_enqueue_style('my_style', plugins_url('assets/css/style.css', __FILE__) , array(),'1.0.0', 'all');

    wp_enqueue_script('splide-js', plugins_url('assets/js/splide.min.js', __FILE__) , array('url_hash','auto_scroll'),'4.1.3', true);
    wp_enqueue_script('url_hash', plugins_url('assets/js/splide-extension-url-hash.min.js', __FILE__) , array(),'0.3.0', true);
    wp_enqueue_script('auto_scroll', plugins_url('assets/js/splide-extension-auto-scroll.min.js', __FILE__) , array(),'0.3.0', true);

    wp_enqueue_script('my_script', plugins_url('assets/js/script.js', __FILE__) , array( 'splide-js' ),'1.0.0', true);

}
add_action( 'wp_enqueue_scripts', 'hulsia_ophtalea_assets' );


add_action('customize_register', 'ophtalea_setting');

/**
 * Create a new customize section
 * @param WP_Customize_Manager $manager
 * @return void
 */
function ophtalea_setting(WP_Customize_Manager $manager)
{


    $manager->add_section('team_setting', [
        'title' => 'Titre de la section équipe ',
    ]);




    //Create a setting and add control Credit
    $manager->add_setting('title', array(
        'default' => 'Notre équipe',
        'sanitize_callback' => 'sanitize_text'
    ));

    $manager->add_control(new WP_Customize_Control(
        $manager,
        'credit',
        array(
            'label' => 'Text',
            'section' => 'team_setting',
            'settings' => 'title',
            'type' => 'text'
        )
    ));

}


function sanitize_text($text)
{
    return sanitize_text_field($text);
}


function ophtalea_team():void
{
    register_post_type(
        'team',
        [   'label'=> __('team', 'ophtalea'),
            'menu_icon'=> 'dashicons-buddicons-buddypress-logo',
            'labels'=> [
                'name'                     => __('Equipe', 'ophtalea'),
                'singular_name'            => __('Equipe', 'ophtalea'),
                'edit_item'                =>  __('Modifier un équipe', 'ophtalea'),
                'new_item'                 =>  __('Ajouter un équipe', 'ophtalea'),
                'view_item'                =>  __('Voir équipe', 'ophtalea'),
                'view_items'               =>  __('Voir les équipes', 'ophtalea'),
                'all_items'                => __('Tout les équipes', 'ophtalea'),
            ],
            'has_archive'=> false,
            'public'=> true,
            'hierarchical'=> false,
            'exclude_from_search'=> true,
            'publicly_queryable'  => false,
            'supports'=>['title','editor','thumbnail'],
        ]
    );
}
add_action('init', 'ophtalea_team');

function get_team() {
    $args = array(
        'post_type'      => 'team',
        'orderby'   => 'date',
        'order' => 'ASC',
    );
    $slides  = new WP_Query($args);
    ob_start();
    include('template/slide_team.php');
    wp_reset_query();
    $result = ob_get_contents();
    ob_end_clean();
    return $result;
}
// register shortcode
add_shortcode('ophtalea_team', 'get_team');


function ophtalea_center():void
{
    register_post_type(
        'center',
        [   'label'=> __('center', 'ophtalea'),
            'menu_icon'=> 'dashicons-admin-multisite',
            'labels'=> [
                'name'                     => __('Centre', 'ophtalea'),
                'singular_name'            => __('Centre', 'ophtalea'),
                'edit_item'                =>  __('Modifier un centre', 'ophtalea'),
                'new_item'                 =>  __('Ajouter un centre', 'ophtalea'),
                'view_item'                =>  __('Voir centre', 'ophtalea'),
                'view_items'               =>  __('Voir les centres', 'ophtalea'),
                'all_items'                => __('Tout les centres', 'ophtalea'),
            ],
            'has_archive'=> false,
            'public'=> true,
            'hierarchical'=> false,
            'exclude_from_search'=> true,
            'publicly_queryable'  => false,
            'supports'=>['title','thumbnail'],
        ]
    );
}
add_action('init', 'ophtalea_center');

function get_center() {
    $args = array(
        'post_type'      => 'center',
        'orderby'   => 'date',
        'order' => 'ASC',
    );
    $slides  = new WP_Query($args);
    ob_start();
    include('template/slide_center.php');
    wp_reset_query();
    $result = ob_get_contents();
    ob_end_clean();
    return $result;
}
// register shortcode
add_shortcode('ophtalea_center', 'get_center');

register_activation_hook(__FILE__,'flush_rewrite_rules');
register_deactivation_hook(__FILE__,'flush_rewrite_rules');
